/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.api.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    public static List<Class<?>> find(String packageName) {
        ArrayList classes = new ArrayList();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource.getProtocol().equals("file")) {
                    File directory = new File(resource.getFile());
                    classes.addAll(ClassScanner.findClassesInDirectory(directory, packageName));
                    continue;
                }
                if (!resource.getProtocol().equals("jar")) continue;
                String jarPath = resource.getPath().substring(5, resource.getPath().indexOf("!"));
                classes.addAll(ClassScanner.findClassesInJar(jarPath, packageName));
            }
        }
        catch (Exception e) {
            System.err.println("Error scanning package " + packageName + ": " + e.getMessage());
            e.printStackTrace();
        }
        return classes;
    }

    private static List<Class<?>> findClassesInDirectory(File directory, String packageName) {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return classes;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(ClassScanner.findClassesInDirectory(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                String className = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6);
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return classes;
    }

    private static List<Class<?>> findClassesInJar(String jarPath, String packageName) {
        ArrayList classes = new ArrayList();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarFile jarFile = new JarFile(jarPath);){
                Enumeration<JarEntry> entries = jarFile.entries();
                String packagePath = packageName.replace('.', '/');
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(packagePath) || !name.endsWith(".class")) continue;
                    String className = name.replace('/', '.').substring(0, name.length() - 6);
                    try {
                        classes.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("Error scanning JAR " + jarPath + ": " + e.getMessage());
        }
        return classes;
    }
}

