/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.api.ui;

import com.aragon.client.api.config.ConfigGroup;
import com.aragon.client.api.config.ConfigItem;
import com.aragon.client.api.event.ConfigChangedEvent;
import com.aragon.client.api.event.Subscribe;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.client.api.plugin.PluginManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class PluginPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(43, 43, 43);
    private static final Color FIELD_BG = new Color(60, 60, 60);
    private static final Color TEXT_COLOR = Color.LIGHT_GRAY;
    private static final Color ACCENT_COLOR = new Color(255, 152, 31);
    private static final Color DISABLED_COLOR = new Color(100, 100, 100);
    private static final Font TITLE_FONT = new Font("Dialog", 1, 16);
    private static final Font LABEL_FONT = new Font("Dialog", 0, 12);
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 30;
    private final Plugin plugin;
    private final PluginManager pluginManager;
    private Map<String, CustomSlider> alphaSliders = new HashMap<String, CustomSlider>();
    private boolean registeredToEventBus = false;

    public PluginPanel(Plugin plugin, PluginManager pluginManager) {
        this.plugin = plugin;
        this.pluginManager = pluginManager;
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(BG_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.buildUI();
        if (pluginManager != null && pluginManager.getEventBus() != null) {
            pluginManager.getEventBus().register(this);
            this.registeredToEventBus = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChangedEvent event) {
        String configGroup;
        Object config = this.plugin.getConfig();
        if (config != null && config.getClass().isAnnotationPresent(ConfigGroup.class) && (configGroup = config.getClass().getAnnotation(ConfigGroup.class).value()).equals(event.getConfigGroup())) {
            SwingUtilities.invokeLater(() -> this.refreshUI());
        }
    }

    public void refreshUI() {
        this.removeAll();
        this.alphaSliders.clear();
        this.buildUI();
        this.revalidate();
        this.repaint();
    }

    public void cleanup() {
        if (this.registeredToEventBus && this.pluginManager != null && this.pluginManager.getEventBus() != null) {
            this.pluginManager.getEventBus().unregister(this);
            this.registeredToEventBus = false;
        }
    }

    private void buildUI() {
        Object config;
        PluginInfo info = this.plugin.getClass().getAnnotation(PluginInfo.class);
        if (info != null) {
            JTextArea titleArea = new JTextArea(info.name());
            titleArea.setFont(TITLE_FONT);
            titleArea.setForeground(TEXT_COLOR);
            titleArea.setBackground(BG_COLOR);
            titleArea.setLineWrap(true);
            titleArea.setWrapStyleWord(true);
            titleArea.setEditable(false);
            titleArea.setFocusable(false);
            titleArea.setAlignmentX(0.0f);
            titleArea.setMaximumSize(new Dimension(230, Integer.MAX_VALUE));
            this.add(titleArea);
            if (!info.description().isEmpty()) {
                JTextArea descArea = new JTextArea(info.description());
                descArea.setFont(LABEL_FONT);
                descArea.setForeground(TEXT_COLOR.darker());
                descArea.setBackground(BG_COLOR);
                descArea.setLineWrap(true);
                descArea.setWrapStyleWord(true);
                descArea.setEditable(false);
                descArea.setFocusable(false);
                descArea.setAlignmentX(0.0f);
                descArea.setMaximumSize(new Dimension(230, Integer.MAX_VALUE));
                descArea.setBorder(new EmptyBorder(5, 0, 10, 0));
                this.add(descArea);
            }
            this.add(Box.createVerticalStrut(10));
            this.add(this.createSeparator());
            this.add(Box.createVerticalStrut(10));
        }
        if ((config = this.plugin.getConfig()) == null) {
            JLabel noConfigLabel = new JLabel("No configuration available");
            noConfigLabel.setForeground(TEXT_COLOR);
            noConfigLabel.setAlignmentX(0.0f);
            this.add(noConfigLabel);
            return;
        }
        List<Method> orderedMethods = this.getConfigMethodsInOrder(config.getClass());
        for (Method method : orderedMethods) {
            ConfigItem item;
            JComponent control;
            if (!method.isAnnotationPresent(ConfigItem.class) || (control = this.createControlForConfigItem(config, method, item = method.getAnnotation(ConfigItem.class))) == null) continue;
            this.add(control);
            this.add(Box.createVerticalStrut(15));
        }
        this.add(Box.createVerticalGlue());
    }

    private List<Method> getConfigMethodsInOrder(Class<?> configClass) {
        Field[] fields;
        ArrayList<Method> orderedMethods = new ArrayList<Method>();
        Field[] fieldArray = fields = configClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            String getterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String isGetterName = "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Method getter = configClass.getMethod(getterName, new Class[0]);
                if (getter.isAnnotationPresent(ConfigItem.class)) {
                    orderedMethods.add(getter);
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    Method getter = configClass.getMethod(isGetterName, new Class[0]);
                    if (getter.isAnnotationPresent(ConfigItem.class)) {
                        orderedMethods.add(getter);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return orderedMethods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JComponent createControlForConfigItem(Object config, Method getter, ConfigItem item) {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.setBackground(BG_COLOR);
        container.setAlignmentX(0.0f);
        container.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        JTextArea label = new JTextArea(item.name());
        label.setFont(LABEL_FONT);
        label.setForeground(TEXT_COLOR);
        label.setBackground(BG_COLOR);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setEditable(false);
        label.setFocusable(false);
        label.setAlignmentX(0.0f);
        label.setMaximumSize(new Dimension(230, Integer.MAX_VALUE));
        container.add(label);
        if (!item.description().isEmpty()) {
            JTextArea descArea = new JTextArea(item.description());
            descArea.setFont(new Font("Dialog", 0, 10));
            descArea.setForeground(TEXT_COLOR.darker());
            descArea.setBackground(BG_COLOR);
            descArea.setLineWrap(true);
            descArea.setWrapStyleWord(true);
            descArea.setEditable(false);
            descArea.setFocusable(false);
            descArea.setAlignmentX(0.0f);
            descArea.setMaximumSize(new Dimension(230, Integer.MAX_VALUE));
            container.add(descArea);
        }
        container.add(Box.createVerticalStrut(5));
        Class<?> returnType = getter.getReturnType();
        final boolean isFinalField = this.isCorrespondingFieldFinal(config.getClass(), getter);
        try {
            getter.setAccessible(true);
            Object currentValue = getter.invoke(config, new Object[0]);
            String configGroup = "";
            if (config.getClass().isAnnotationPresent(ConfigGroup.class)) {
                configGroup = config.getClass().getAnnotation(ConfigGroup.class).value();
            }
            String finalConfigGroup = configGroup;
            if (returnType == Color.class) {
                Color color = (Color)currentValue;
                String alphaKey = String.valueOf(item.key()) + "Alpha";
                Method alphaGetter = this.findAlphaGetter(config.getClass(), alphaKey);
                CustomColorPickerWithAlpha colorPicker = new CustomColorPickerWithAlpha(color, alphaGetter != null);
                colorPicker.setAlignmentX(0.0f);
                if (isFinalField) {
                    colorPicker.setEnabled(false);
                    colorPicker.setForeground(DISABLED_COLOR);
                }
                if (alphaGetter != null) {
                    try {
                        alphaGetter.setAccessible(true);
                        int alpha = (Integer)alphaGetter.invoke(config, new Object[0]);
                        colorPicker.setAlpha(alpha);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (!isFinalField) {
                    colorPicker.addColorChangeListener(newColor -> {
                        try {
                            Method setter = this.findSetter(config.getClass(), getter);
                            if (setter != null) {
                                Object oldValue = getter.invoke(config, new Object[0]);
                                setter.invoke(config, newColor);
                                this.pluginManager.getConfigManager().save(config);
                                ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, newColor);
                                this.pluginManager.triggerEvent(event);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                    if (alphaGetter != null) {
                        colorPicker.addAlphaChangeListener(newAlpha -> {
                            try {
                                Method alphaSetter = this.findSetter(config.getClass(), alphaGetter);
                                if (alphaSetter != null) {
                                    Object oldValue = alphaGetter.invoke(config, new Object[0]);
                                    alphaSetter.invoke(config, newAlpha);
                                    this.pluginManager.getConfigManager().save(config);
                                    ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, alphaKey, oldValue, newAlpha);
                                    this.pluginManager.triggerEvent(event);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        });
                    }
                }
                container.add(colorPicker);
                if (alphaGetter == null) return container;
                this.alphaSliders.put(alphaKey, null);
                return container;
            }
            if (returnType == Boolean.TYPE || returnType == Boolean.class) {
                CustomToggle toggle = new CustomToggle((Boolean)currentValue);
                toggle.setAlignmentX(0.0f);
                toggle.setEnabled(!isFinalField);
                if (!isFinalField) {
                    toggle.addActionListener(e -> {
                        try {
                            Method setter = this.findSetter(config.getClass(), getter);
                            if (setter != null) {
                                Object oldValue = getter.invoke(config, new Object[0]);
                                setter.invoke(config, toggle.isSelected());
                                this.pluginManager.getConfigManager().save(config);
                                ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, toggle.isSelected());
                                this.pluginManager.triggerEvent(event);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
                container.add(toggle);
                return container;
            }
            if (returnType == String.class && item.options().length > 0) {
                CustomComboBox comboBox = new CustomComboBox(item.options());
                comboBox.setSelectedItem(currentValue);
                comboBox.setAlignmentX(0.0f);
                comboBox.setEnabled(!isFinalField);
                comboBox.setPreferredSize(new Dimension(200, 30));
                comboBox.setMaximumSize(new Dimension(200, 30));
                comboBox.setMinimumSize(new Dimension(200, 30));
                if (!isFinalField) {
                    comboBox.addActionListener(e -> {
                        try {
                            Method setter = this.findSetter(config.getClass(), getter);
                            if (setter != null) {
                                Object oldValue = getter.invoke(config, new Object[0]);
                                setter.invoke(config, comboBox.getSelectedItem());
                                this.pluginManager.getConfigManager().save(config);
                                ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, comboBox.getSelectedItem());
                                this.pluginManager.triggerEvent(event);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
                container.add(comboBox);
                return container;
            }
            if (returnType == Integer.TYPE || returnType == Integer.class) {
                if (this.alphaSliders.containsKey(item.key())) {
                    return null;
                }
                int value = (Integer)currentValue;
                if (item.min() != Integer.MIN_VALUE && item.max() != Integer.MAX_VALUE) {
                    JPanel sliderPanel = new JPanel(new BorderLayout(5, 0));
                    sliderPanel.setBackground(BG_COLOR);
                    sliderPanel.setAlignmentX(0.0f);
                    sliderPanel.setPreferredSize(new Dimension(200, 40));
                    sliderPanel.setMaximumSize(new Dimension(200, 40));
                    sliderPanel.setMinimumSize(new Dimension(200, 40));
                    CustomSlider slider = new CustomSlider(item.min(), item.max(), value);
                    slider.setEnabled(!isFinalField);
                    JLabel valueLabel = new JLabel(String.valueOf(value));
                    valueLabel.setForeground(isFinalField ? DISABLED_COLOR : TEXT_COLOR);
                    valueLabel.setPreferredSize(new Dimension(40, 20));
                    valueLabel.setFont(new Font("Dialog", 1, 11));
                    if (!isFinalField) {
                        slider.addChangeListener(e -> {
                            valueLabel.setText(String.valueOf(slider.getValue()));
                            if (!slider.getValueIsAdjusting()) {
                                try {
                                    Method setter = this.findSetter(config.getClass(), getter);
                                    if (setter != null) {
                                        Object oldValue = getter.invoke(config, new Object[0]);
                                        setter.invoke(config, slider.getValue());
                                        this.pluginManager.getConfigManager().save(config);
                                        ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, slider.getValue());
                                        this.pluginManager.triggerEvent(event);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                    sliderPanel.add((Component)slider, "Center");
                    sliderPanel.add((Component)valueLabel, "East");
                    container.add(sliderPanel);
                    return container;
                }
                CustomTextField textField = new CustomTextField(String.valueOf(value));
                textField.setAlignmentX(0.0f);
                textField.setEnabled(!isFinalField);
                textField.setEditable(!isFinalField);
                textField.setPreferredSize(new Dimension(200, 30));
                textField.setMaximumSize(new Dimension(200, 30));
                textField.setMinimumSize(new Dimension(200, 30));
                if (isFinalField) {
                    textField.setForeground(DISABLED_COLOR);
                    textField.setBackground(new Color(50, 50, 50));
                }
                if (!isFinalField) {
                    textField.addActionListener(e -> {
                        try {
                            int newValue = Integer.parseInt(textField.getText());
                            Method setter = this.findSetter(config.getClass(), getter);
                            if (setter != null) {
                                Object oldValue = getter.invoke(config, new Object[0]);
                                setter.invoke(config, newValue);
                                this.pluginManager.getConfigManager().save(config);
                                ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, newValue);
                                this.pluginManager.triggerEvent(event);
                            }
                        }
                        catch (NumberFormatException ex) {
                            textField.setText(String.valueOf(value));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
                container.add(textField);
                return container;
            }
            if (returnType != String.class) return container;
            CustomTextField textField = new CustomTextField((String)currentValue);
            textField.setAlignmentX(0.0f);
            textField.setEnabled(!isFinalField);
            textField.setEditable(!isFinalField);
            textField.setPreferredSize(new Dimension(200, 30));
            textField.setMaximumSize(new Dimension(200, 30));
            textField.setMinimumSize(new Dimension(200, 30));
            if (isFinalField) {
                textField.setForeground(DISABLED_COLOR);
                textField.setBackground(new Color(50, 50, 50));
            }
            ((AbstractDocument)textField.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (isFinalField) {
                        return;
                    }
                    if (fb.getDocument().getLength() + string.length() <= 24) {
                        super.insertString(fb, offset, string, attr);
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (isFinalField) {
                        return;
                    }
                    if (fb.getDocument().getLength() - length + (text != null ? text.length() : 0) <= 24) {
                        super.replace(fb, offset, length, text, attrs);
                    }
                }
            });
            if (!isFinalField) {
                textField.addActionListener(e -> {
                    try {
                        Method setter = this.findSetter(config.getClass(), getter);
                        if (setter != null) {
                            Object oldValue = getter.invoke(config, new Object[0]);
                            setter.invoke(config, textField.getText());
                            this.pluginManager.getConfigManager().save(config);
                            ConfigChangedEvent event = new ConfigChangedEvent(finalConfigGroup, item.key(), oldValue, textField.getText());
                            this.pluginManager.triggerEvent(event);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            }
            container.add(textField);
            return container;
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return container;
    }

    private boolean isCorrespondingFieldFinal(Class<?> configClass, Method getter) {
        String fieldName;
        String getterName = getter.getName();
        if (getterName.startsWith("get")) {
            fieldName = String.valueOf(Character.toLowerCase(getterName.charAt(3))) + getterName.substring(4);
        } else if (getterName.startsWith("is")) {
            fieldName = String.valueOf(Character.toLowerCase(getterName.charAt(2))) + getterName.substring(3);
        } else {
            return false;
        }
        try {
            Field field = configClass.getDeclaredField(fieldName);
            return PluginManager.isFieldFinal(field);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private Method findAlphaGetter(Class<?> clazz, String alphaKey) {
        try {
            String getterName = "get" + Character.toUpperCase(alphaKey.charAt(0)) + alphaKey.substring(1);
            return clazz.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Method findSetter(Class<?> clazz, Method getter) {
        String setterName;
        String getterName = getter.getName();
        if (getterName.startsWith("get")) {
            setterName = "set" + getterName.substring(3);
        } else if (getterName.startsWith("is")) {
            setterName = "set" + getterName.substring(2);
        } else {
            return null;
        }
        try {
            return clazz.getMethod(setterName, getter.getReturnType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private JComponent createSeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setForeground(new Color(60, 60, 60));
        separator.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        separator.setAlignmentX(0.0f);
        return separator;
    }

    public static JScrollPane createCustomScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view);
        scrollPane.setBackground(BG_COLOR);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getVerticalScrollBar().setUI(new BasicScrollBarUI(){
            private final int SCROLLBAR_WIDTH = 8;
            private final int MARGIN = 2;

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = new Color(100, 100, 100);
                this.thumbHighlightColor = new Color(120, 120, 120);
                this.thumbDarkShadowColor = new Color(100, 100, 100);
                this.thumbLightShadowColor = new Color(100, 100, 100);
                this.trackColor = BG_COLOR;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return this.createZeroButton();
            }

            private JButton createZeroButton() {
                JButton button = new JButton();
                button.setPreferredSize(new Dimension(0, 0));
                button.setMinimumSize(new Dimension(0, 0));
                button.setMaximumSize(new Dimension(0, 0));
                return button;
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int x = thumbBounds.x + 2;
                int y = thumbBounds.y;
                int width = 4;
                int height = thumbBounds.height;
                if (this.isThumbRollover()) {
                    g2.setColor(this.thumbHighlightColor);
                } else {
                    g2.setColor(this.thumbColor);
                }
                g2.fillRoundRect(x, y, width, height, width, width);
                g2.dispose();
            }

            @Override
            protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(BG_COLOR);
                g2.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
                g2.dispose();
            }
        });
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        return scrollPane;
    }

    static class CustomColorPickerWithAlpha
    extends JPanel {
        private Color currentColor;
        private int currentAlpha = 255;
        private JButton colorButton;
        private CustomSlider alphaSlider;
        private JLabel alphaLabel;
        private List<ColorChangeListener> colorListeners = new ArrayList<ColorChangeListener>();
        private List<AlphaChangeListener> alphaListeners = new ArrayList<AlphaChangeListener>();
        private boolean hasAlpha;

        public CustomColorPickerWithAlpha(Color initialColor, boolean hasAlpha) {
            this.currentColor = initialColor;
            this.currentAlpha = initialColor.getAlpha();
            this.hasAlpha = hasAlpha;
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(BG_COLOR);
            this.setAlignmentX(0.0f);
            JPanel colorPanel = new JPanel(new FlowLayout(0, 0, 0));
            colorPanel.setBackground(BG_COLOR);
            colorPanel.setMaximumSize(new Dimension(200, 50));
            this.colorButton = new JButton(){

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentAlpha));
                    g2.fillRoundRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, 4, 4);
                    g2.setColor(new Color(80, 80, 80));
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.drawRoundRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, 4, 4);
                    g2.dispose();
                }
            };
            this.colorButton.setPreferredSize(new Dimension(50, 40));
            this.colorButton.setContentAreaFilled(false);
            this.colorButton.setBorderPainted(false);
            this.colorButton.setFocusPainted(false);
            this.colorButton.setCursor(new Cursor(12));
            this.colorButton.setToolTipText("Click to open color picker");
            this.colorButton.addActionListener(e -> this.showColorPickerDialog());
            colorPanel.add(this.colorButton);
            colorPanel.add(Box.createHorizontalStrut(10));
            JPanel rgbPanel = new JPanel();
            rgbPanel.setLayout(new BoxLayout(rgbPanel, 1));
            rgbPanel.setBackground(BG_COLOR);
            JLabel rgbLabel = new JLabel(String.format("RGB: %d, %d, %d", this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue()));
            rgbLabel.setForeground(TEXT_COLOR);
            rgbLabel.setFont(new Font("Dialog", 0, 11));
            JLabel hexLabel = new JLabel(String.format("HEX: #%06X", this.currentColor.getRGB() & 0xFFFFFF));
            hexLabel.setForeground(TEXT_COLOR.darker());
            hexLabel.setFont(new Font("Dialog", 0, 10));
            rgbPanel.add(rgbLabel);
            rgbPanel.add(hexLabel);
            colorPanel.add(rgbPanel);
            this.add(colorPanel);
            if (hasAlpha) {
                this.add(Box.createVerticalStrut(5));
                JPanel alphaPanel = new JPanel(new BorderLayout(5, 0));
                alphaPanel.setBackground(BG_COLOR);
                alphaPanel.setAlignmentX(0.0f);
                alphaPanel.setMaximumSize(new Dimension(200, 40));
                this.alphaSlider = new CustomSlider(0, 255, this.currentAlpha);
                this.alphaLabel = new JLabel(String.valueOf(this.currentAlpha));
                this.alphaLabel.setForeground(TEXT_COLOR);
                this.alphaLabel.setPreferredSize(new Dimension(40, 20));
                this.alphaLabel.setFont(new Font("Dialog", 1, 11));
                this.alphaSlider.addChangeListener(e -> {
                    this.currentAlpha = this.alphaSlider.getValue();
                    this.alphaLabel.setText(String.valueOf(this.currentAlpha));
                    this.colorButton.repaint();
                    if (!this.alphaSlider.getValueIsAdjusting()) {
                        this.notifyAlphaListeners(this.currentAlpha);
                    }
                });
                alphaPanel.add((Component)this.alphaSlider, "Center");
                alphaPanel.add((Component)this.alphaLabel, "East");
                this.add(alphaPanel);
            }
        }

        public void setAlpha(int alpha) {
            this.currentAlpha = alpha;
            if (this.alphaSlider != null) {
                this.alphaSlider.setValue(alpha);
                this.alphaLabel.setText(String.valueOf(alpha));
            }
            this.colorButton.repaint();
        }

        private void showColorPickerDialog() {
            JDialog dialog = new JDialog();
            dialog.setTitle("Choose Color");
            dialog.setModal(true);
            dialog.setLayout(new BorderLayout(10, 10));
            dialog.getContentPane().setBackground(BG_COLOR);
            JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
            mainPanel.setBackground(BG_COLOR);
            mainPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            HSBColorPickerPanel pickerPanel = new HSBColorPickerPanel(this.currentColor);
            pickerPanel.addColorChangeListener((Color color) -> {
                this.currentColor = color;
                this.updateLabels();
                this.colorButton.repaint();
            });
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 0));
            buttonPanel.setBackground(BG_COLOR);
            JButton okButton = new JButton("OK");
            this.styleDialogButton(okButton, true);
            okButton.addActionListener(e -> {
                this.notifyColorListeners(this.currentColor);
                dialog.dispose();
            });
            JButton cancelButton = new JButton("Cancel");
            this.styleDialogButton(cancelButton, false);
            cancelButton.addActionListener(e -> dialog.dispose());
            buttonPanel.add(cancelButton);
            buttonPanel.add(okButton);
            mainPanel.add((Component)pickerPanel, "Center");
            mainPanel.add((Component)buttonPanel, "South");
            dialog.add(mainPanel);
            dialog.pack();
            dialog.setLocationRelativeTo(this.colorButton);
            dialog.setVisible(true);
        }

        private void styleDialogButton(final JButton button, final boolean primary) {
            button.setBackground(primary ? ACCENT_COLOR : FIELD_BG);
            button.setForeground(primary ? Color.WHITE : TEXT_COLOR);
            button.setFont(new Font("Dialog", 1, 12));
            button.setFocusPainted(false);
            button.setBorderPainted(false);
            button.setPreferredSize(new Dimension(80, 30));
            button.setCursor(new Cursor(12));
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    button.setBackground(primary ? new Color(255, 170, 50) : new Color(80, 80, 80));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    button.setBackground(primary ? ACCENT_COLOR : FIELD_BG);
                }
            });
        }

        private void updateLabels() {
            Component[] components;
            Component[] componentArray = components = ((JPanel)this.getComponent(0)).getComponents();
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                JPanel panel;
                Component[] labels;
                Component comp = componentArray[n2];
                if (comp instanceof JPanel && (labels = (panel = (JPanel)comp).getComponents()).length >= 2) {
                    if (labels[0] instanceof JLabel) {
                        ((JLabel)labels[0]).setText(String.format("RGB: %d, %d, %d", this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue()));
                    }
                    if (labels[1] instanceof JLabel) {
                        ((JLabel)labels[1]).setText(String.format("HEX: #%06X", this.currentColor.getRGB() & 0xFFFFFF));
                    }
                }
                ++n2;
            }
        }

        public void addColorChangeListener(ColorChangeListener listener) {
            this.colorListeners.add(listener);
        }

        public void addAlphaChangeListener(AlphaChangeListener listener) {
            this.alphaListeners.add(listener);
        }

        private void notifyColorListeners(Color color) {
            for (ColorChangeListener listener : this.colorListeners) {
                listener.onColorChanged(color);
            }
        }

        private void notifyAlphaListeners(int alpha) {
            for (AlphaChangeListener listener : this.alphaListeners) {
                listener.onAlphaChanged(alpha);
            }
        }

        public Color getColor() {
            return this.currentColor;
        }

        public int getAlpha() {
            return this.currentAlpha;
        }

        public static interface AlphaChangeListener {
            public void onAlphaChanged(int var1);
        }

        public static interface ColorChangeListener {
            public void onColorChanged(Color var1);
        }
    }

    static class CustomComboBox
    extends JComboBox<String> {
        public CustomComboBox(String[] items) {
            super(items);
            this.setBackground(FIELD_BG);
            this.setForeground(TEXT_COLOR);
            this.setBorder(BorderFactory.createLineBorder(new Color(80, 80, 80), 1));
            this.setFont(new Font("Dialog", 0, 12));
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setBackground(isSelected ? new Color(255, 152, 31, 100) : FIELD_BG);
                    this.setForeground(TEXT_COLOR);
                    this.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
                    return this;
                }
            });
        }
    }

    static class CustomSlider
    extends JSlider {
        private static final int THUMB_SIZE = 16;

        public CustomSlider(int min, int max, int value) {
            super(min, max, value);
            this.setBackground(BG_COLOR);
            this.setForeground(ACCENT_COLOR);
            this.setUI(new BasicSliderUI(this){

                @Override
                protected Dimension getThumbSize() {
                    return new Dimension(16, 16);
                }

                @Override
                public void paintTrack(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int trackY = this.trackRect.y + this.trackRect.height / 2 - 2;
                    g2.setColor(new Color(80, 80, 80));
                    g2.fillRoundRect(this.trackRect.x, trackY, this.trackRect.width, 4, 4, 4);
                    int filledWidth = (int)((double)(this.slider.getValue() - this.slider.getMinimum()) / (double)(this.slider.getMaximum() - this.slider.getMinimum()) * (double)this.trackRect.width);
                    g2.setColor(ACCENT_COLOR);
                    g2.fillRoundRect(this.trackRect.x, trackY, filledWidth, 4, 4, 4);
                    g2.dispose();
                }

                @Override
                public void paintThumb(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int thumbX = this.thumbRect.x + (this.thumbRect.width - 16) / 2;
                    int thumbY = this.thumbRect.y + (this.thumbRect.height - 16) / 2;
                    g2.setColor(Color.WHITE);
                    g2.fillOval(thumbX, thumbY, 16, 16);
                    g2.setColor(ACCENT_COLOR);
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.drawOval(thumbX + 1, thumbY + 1, 14, 14);
                    g2.dispose();
                }
            });
        }
    }

    static class CustomTextField
    extends JTextField {
        public CustomTextField(String text) {
            super(text);
            this.setBackground(FIELD_BG);
            this.setForeground(TEXT_COLOR);
            this.setCaretColor(TEXT_COLOR);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(80, 80, 80), 1), BorderFactory.createEmptyBorder(5, 8, 5, 8)));
            this.setFont(new Font("Dialog", 0, 12));
        }
    }

    static class CustomToggle
    extends JToggleButton {
        private static final int WIDTH = 40;
        private static final int HEIGHT = 20;

        public CustomToggle(boolean selected) {
            this.setSelected(selected);
            this.setPreferredSize(new Dimension(40, 20));
            this.setMaximumSize(new Dimension(40, 20));
            this.setMinimumSize(new Dimension(40, 20));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setCursor(new Cursor(12));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.isSelected() ? ACCENT_COLOR : new Color(80, 80, 80));
            g2.fillRoundRect(0, 0, 40, 20, 20, 20);
            int knobX = this.isSelected() ? 20 : 0;
            g2.setColor(Color.WHITE);
            g2.fillOval(knobX + 2, 2, 16, 16);
            g2.dispose();
        }
    }

    static class HSBColorPickerPanel
    extends JPanel {
        private static final int PICKER_WIDTH = 200;
        private static final int PICKER_HEIGHT = 200;
        private static final int HUE_WIDTH = 20;
        private static final int PICKER_CIRCLE_RADIUS = 12;
        private static final int HUE_CIRCLE_RADIUS = 12;
        private float currentHue = 0.0f;
        private float currentSaturation = 1.0f;
        private float currentBrightness = 1.0f;
        private int lastColorX = 200;
        private int lastColorY = 0;
        private int lastHueY = 0;
        private BufferedImage pickerImage;
        private BufferedImage hueImage;
        private List<ColorChangeListener> listeners = new ArrayList<ColorChangeListener>();

        public HSBColorPickerPanel(Color initialColor) {
            this.setPreferredSize(new Dimension(250, 300));
            this.setBackground(BG_COLOR);
            float[] hsb = Color.RGBtoHSB(initialColor.getRed(), initialColor.getGreen(), initialColor.getBlue(), null);
            this.currentHue = hsb[0];
            this.currentSaturation = hsb[1];
            this.currentBrightness = hsb[2];
            this.lastColorX = (int)(this.currentSaturation * 200.0f);
            this.lastColorY = (int)((1.0f - this.currentBrightness) * 200.0f);
            this.lastHueY = (int)((1.0f - this.currentHue) * 200.0f);
            this.generatePickerImage();
            this.generateHueImage();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handleMouseClick(e.getX(), e.getY());
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.handleMouseClick(e.getX(), e.getY());
                }
            });
        }

        private void generatePickerImage() {
            this.pickerImage = new BufferedImage(200, 200, 1);
            int x = 0;
            while (x < 200) {
                int y = 0;
                while (y < 200) {
                    float saturation = (float)x / 200.0f;
                    float brightness = 1.0f - (float)y / 200.0f;
                    int rgb = Color.HSBtoRGB(this.currentHue, saturation, brightness);
                    this.pickerImage.setRGB(x, y, rgb);
                    ++y;
                }
                ++x;
            }
        }

        private void generateHueImage() {
            this.hueImage = new BufferedImage(20, 200, 1);
            int y = 0;
            while (y < 200) {
                float hue = 1.0f - (float)y / 200.0f;
                int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                int x = 0;
                while (x < 20) {
                    this.hueImage.setRGB(x, y, rgb);
                    ++x;
                }
                ++y;
            }
        }

        private void handleMouseClick(int mouseX, int mouseY) {
            int pickerX = 10;
            int pickerY = 50;
            int relativeX = mouseX - pickerX;
            int relativeY = mouseY - pickerY;
            if (relativeX >= 0 && relativeX < 200 && relativeY >= 0 && relativeY < 200) {
                this.currentSaturation = Math.max(0.0f, Math.min(1.0f, (float)relativeX / 200.0f));
                this.currentBrightness = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)relativeY / 200.0f));
                this.lastColorX = relativeX;
                this.lastColorY = relativeY;
                this.notifyColorChange();
                this.repaint();
            } else if (relativeX >= 200 && relativeX < 220 && relativeY >= 0 && relativeY < 200) {
                this.currentHue = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)relativeY / 200.0f));
                this.lastHueY = relativeY;
                this.generatePickerImage();
                this.notifyColorChange();
                this.repaint();
            }
        }

        private void notifyColorChange() {
            Color newColor = new Color(Color.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness));
            for (ColorChangeListener listener : this.listeners) {
                listener.onColorChanged(newColor);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int pickerX = 10;
            int pickerY = 50;
            Color currentColor = new Color(Color.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness));
            g2.setColor(currentColor);
            g2.fillRoundRect(pickerX, 10, 220, 30, 5, 5);
            g2.setColor(new Color(80, 80, 80));
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawRoundRect(pickerX, 10, 220, 30, 5, 5);
            g2.setColor(TEXT_COLOR);
            g2.setFont(new Font("Dialog", 0, 10));
            String rgbText = String.format("RGB: %d, %d, %d  HEX: #%06X", currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentColor.getRGB() & 0xFFFFFF);
            g2.drawString(rgbText, pickerX, pickerY + 200 + 20);
            g2.drawImage((Image)this.pickerImage, pickerX, pickerY, null);
            g2.drawImage((Image)this.hueImage, pickerX + 200, pickerY, null);
            g2.setColor(new Color(80, 80, 80));
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawRect(pickerX, pickerY, 220, 200);
            int circleX = pickerX + this.lastColorX;
            int circleY = pickerY + this.lastColorY;
            g2.setColor(Color.WHITE);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawOval(circleX - 6, circleY - 6, 12, 12);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawOval(circleX - 6 - 1, circleY - 6 - 1, 14, 14);
            int hueCircleX = pickerX + 200 + 10;
            int hueCircleY = pickerY + this.lastHueY;
            g2.setColor(Color.WHITE);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawOval(hueCircleX - 6, hueCircleY - 6, 12, 12);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawOval(hueCircleX - 6 - 1, hueCircleY - 6 - 1, 14, 14);
            g2.dispose();
        }

        public void addColorChangeListener(ColorChangeListener listener) {
            this.listeners.add(listener);
        }

        public static interface ColorChangeListener {
            public void onColorChanged(Color var1);
        }
    }
}

