/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.api.plugin;

import com.aragon.client.api.config.ConfigManager;
import com.aragon.client.api.event.EventBus;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.client.api.util.ClassScanner;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginManager {
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final EventBus eventBus = new EventBus();
    private final ConfigManager configManager;
    private final Map<Class<? extends Plugin>, Boolean> pluginStates = new HashMap<Class<? extends Plugin>, Boolean>();
    public static final int MAX_TEXT_FIELD_LENGTH = 24;

    public PluginManager(String configDirectory) {
        this.configManager = new ConfigManager(configDirectory);
    }

    public void loadPlugins(String basePackage) {
        System.out.println("Scanning for plugins in package: " + basePackage);
        List<Class<?>> foundClasses = ClassScanner.find(basePackage);
        int loadedCount = 0;
        for (Class<?> clazz : foundClasses) {
            if (!Plugin.class.isAssignableFrom(clazz)) continue;
            if (!clazz.isAnnotationPresent(PluginInfo.class)) {
                System.err.println("Plugin class missing @PluginInfo annotation: " + clazz.getSimpleName());
                continue;
            }
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
            try {
                Plugin plugin = (Plugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.configManager.loadConfigFor(plugin);
                this.plugins.add(plugin);
                ++loadedCount;
                PluginInfo info = clazz.getAnnotation(PluginInfo.class);
                this.pluginStates.put(clazz, info.enabledByDefault());
                System.out.println("Loaded plugin: " + info.name());
            }
            catch (Exception e) {
                System.err.println("Failed to load plugin " + clazz.getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.println("Loaded " + loadedCount + " plugin(s)");
    }

    public void startPlugins() {
        for (Plugin plugin : this.plugins) {
            try {
                PluginInfo info = plugin.getClass().getAnnotation(PluginInfo.class);
                if (!this.isPluginEnabled(plugin.getClass())) continue;
                this.eventBus.register(plugin);
                plugin.onStart();
                System.out.println("Started plugin: " + info.name());
            }
            catch (Exception e) {
                System.err.println("Error starting plugin " + plugin.getClass().getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void stopPlugins() {
        for (Plugin plugin : this.plugins) {
            try {
                plugin.onStop();
                this.eventBus.unregister(plugin);
            }
            catch (Exception e) {
                System.err.println("Error stopping plugin: " + e.getMessage());
            }
        }
    }

    public void enablePlugin(Class<? extends Plugin> pluginClass) {
        this.pluginStates.put(pluginClass, true);
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().equals(pluginClass)) continue;
            try {
                this.eventBus.register(plugin);
                plugin.onStart();
                PluginInfo info = plugin.getClass().getAnnotation(PluginInfo.class);
                System.out.println("Enabled plugin: " + info.name());
            }
            catch (Exception e) {
                System.err.println("Error enabling plugin: " + e.getMessage());
                e.printStackTrace();
            }
            break;
        }
    }

    public void disablePlugin(Class<? extends Plugin> pluginClass) {
        this.pluginStates.put(pluginClass, false);
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().equals(pluginClass)) continue;
            try {
                plugin.onStop();
                this.eventBus.unregister(plugin);
                PluginInfo info = plugin.getClass().getAnnotation(PluginInfo.class);
                System.out.println("Disabled plugin: " + info.name());
            }
            catch (Exception e) {
                System.err.println("Error disabling plugin: " + e.getMessage());
                e.printStackTrace();
            }
            break;
        }
    }

    public boolean isPluginEnabled(Class<? extends Plugin> pluginClass) {
        return this.pluginStates.getOrDefault(pluginClass, false);
    }

    public boolean isPluginEnabled(Plugin plugin) {
        return this.isPluginEnabled(plugin.getClass());
    }

    public static boolean isFieldFinal(Field field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public void triggerEvent(Object event) {
        this.eventBus.post(event);
    }

    public List<Plugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

