/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.api.event;

import com.aragon.client.api.event.Subscribe;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventBus {
    private final Map<Class<?>, List<Subscriber>> subscribers = new HashMap();

    public void register(Object listener) {
        if (listener == null) {
            return;
        }
        Method[] methodArray = listener.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Subscribe.class)) {
                Class<?>[] params = method.getParameterTypes();
                if (params.length != 1) {
                    System.err.println("@Subscribe method must have exactly one parameter: " + method.getName());
                } else {
                    Class<?> eventType = params[0];
                    method.setAccessible(true);
                    this.subscribers.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(new Subscriber(listener, method));
                }
            }
            ++n2;
        }
    }

    public void unregister(Object listener) {
        if (listener == null) {
            return;
        }
        for (List<Subscriber> subs : this.subscribers.values()) {
            subs.removeIf(sub -> sub.owner == listener);
        }
    }

    public void post(Object event) {
        if (event == null) {
            return;
        }
        List<Subscriber> subs = this.subscribers.get(event.getClass());
        if (subs == null || subs.isEmpty()) {
            return;
        }
        for (Subscriber sub : subs) {
            try {
                sub.method.invoke(sub.owner, event);
            }
            catch (Exception e) {
                System.err.println("Error dispatching event to " + sub.method.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static class Subscriber {
        final Object owner;
        final Method method;

        Subscriber(Object owner, Method method) {
            this.owner = owner;
            this.method = method;
        }
    }
}

