/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.api.config;

import com.aragon.client.api.config.ConfigGroup;
import com.aragon.client.api.plugin.Plugin;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ConfigManager {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configDir;
    private final Map<String, Object> configCache = new HashMap<String, Object>();

    public ConfigManager(String configDirectory) {
        this.configDir = new File(configDirectory);
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
    }

    public Object loadConfigFor(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        Class<?> pluginClass = plugin.getClass();
        Field configField = null;
        Field[] fieldArray = pluginClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().isAnnotationPresent(ConfigGroup.class)) {
                configField = field;
                break;
            }
            ++n2;
        }
        if (configField == null) {
            return null;
        }
        Class<?> configClass = configField.getType();
        ConfigGroup configGroup = configClass.getAnnotation(ConfigGroup.class);
        String groupName = configGroup.value();
        if (this.configCache.containsKey(groupName)) {
            Object cachedConfig = this.configCache.get(groupName);
            this.injectConfig(plugin, configField, cachedConfig);
            return cachedConfig;
        }
        File configFile = new File(this.configDir, String.valueOf(groupName) + ".json");
        Object config = null;
        try {
            if (configFile.exists()) {
                Throwable throwable = null;
                Object var10_14 = null;
                try (FileReader reader = new FileReader(configFile);){
                    config = this.gson.fromJson((Reader)reader, configClass);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (config == null) {
                config = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.save(config);
            }
            this.configCache.put(groupName, config);
            this.injectConfig(plugin, configField, config);
            return config;
        }
        catch (Exception e) {
            System.err.println("Error loading config for " + pluginClass.getSimpleName() + ": " + e.getMessage());
            e.printStackTrace();
            try {
                config = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.configCache.put(groupName, config);
                this.injectConfig(plugin, configField, config);
                return config;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public void save(Object config) {
        if (config == null) {
            return;
        }
        Class<?> configClass = config.getClass();
        if (!configClass.isAnnotationPresent(ConfigGroup.class)) {
            System.err.println("Config class must be annotated with @ConfigGroup: " + configClass.getSimpleName());
            return;
        }
        ConfigGroup configGroup = configClass.getAnnotation(ConfigGroup.class);
        String groupName = configGroup.value();
        File configFile = new File(this.configDir, String.valueOf(groupName) + ".json");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter writer = new FileWriter(configFile);){
                this.gson.toJson(config, (Appendable)writer);
                this.configCache.put(groupName, config);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("Error saving config " + groupName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Object getConfig(String groupName) {
        return this.configCache.get(groupName);
    }

    private void injectConfig(Plugin plugin, Field configField, Object config) {
        try {
            configField.setAccessible(true);
            configField.set(plugin, config);
        }
        catch (Exception e) {
            System.err.println("Error injecting config into plugin: " + e.getMessage());
        }
    }
}

