/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client;

import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ScreenManager {
    private GraphicsDevice vc;

    public ScreenManager() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.vc = e.getDefaultScreenDevice();
    }

    public DisplayMode[] getCompatibleDisplayModes() {
        return this.vc.getDisplayModes();
    }

    public DisplayMode findFirstCompatibleMode(DisplayMode[] modes) {
        DisplayMode[] goodModes = this.vc.getDisplayModes();
        int x = 0;
        while (x < modes.length) {
            int y = 0;
            while (y < goodModes.length) {
                if (this.displayModesMatch(modes[x], goodModes[y])) {
                    return modes[x];
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    public DisplayMode getCurrentDisplayMode() {
        return this.vc.getDisplayMode();
    }

    public boolean displayModesMatch(DisplayMode m1, DisplayMode m2) {
        if (m1.getWidth() != m2.getWidth() || m1.getHeight() != m2.getHeight()) {
            return false;
        }
        if (m1.getBitDepth() != -1 && m2.getBitDepth() != -1 && m1.getBitDepth() != m2.getBitDepth()) {
            return false;
        }
        return m1.getRefreshRate() == 0 || m2.getRefreshRate() == 0 || m1.getRefreshRate() == m2.getRefreshRate();
    }

    public void setFullScreen(DisplayMode dm) {
        JFrame f = new JFrame();
        f.setUndecorated(true);
        f.setIgnoreRepaint(true);
        f.setResizable(false);
        this.vc.setFullScreenWindow(f);
        if (dm != null && this.vc.isDisplayChangeSupported()) {
            try {
                this.vc.setDisplayMode(dm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        f.createBufferStrategy(2);
    }

    public void setFullScreen(DisplayMode dm, Frame window) throws Exception {
        if (this.vc == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.vc = env.getDefaultScreenDevice();
        }
        window.setUndecorated(true);
        window.setResizable(false);
        this.vc.setFullScreenWindow(window);
        if (dm != null && this.vc.isDisplayChangeSupported()) {
            try {
                this.vc.setDisplayMode(dm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeFullScreen() {
        Window w = this.vc.getFullScreenWindow();
        if (w != null) {
            w.dispose();
        }
        this.vc.setFullScreenWindow(null);
    }

    public Graphics2D getGraphics() {
        Window w = this.vc.getFullScreenWindow();
        if (w != null) {
            BufferStrategy s = w.getBufferStrategy();
            return (Graphics2D)s.getDrawGraphics();
        }
        return null;
    }

    public void update() {
        BufferStrategy s;
        Window w = this.vc.getFullScreenWindow();
        if (w != null && !(s = w.getBufferStrategy()).contentsLost()) {
            s.show();
        }
    }

    public Window getFullScreenWindow() {
        return this.vc.getFullScreenWindow();
    }

    public int getWidth() {
        Window w = this.vc.getFullScreenWindow();
        if (w != null) {
            return w.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        Window w = this.vc.getFullScreenWindow();
        if (w != null) {
            return w.getHeight();
        }
        return 0;
    }

    public void restoreScreen() {
        Window w = this.vc.getFullScreenWindow();
        if (w != null) {
            w.dispose();
        }
        this.vc.setFullScreenWindow(null);
    }

    public BufferedImage createCompatibleImage(int w, int h, int t) {
        Window win = this.vc.getFullScreenWindow();
        if (win != null) {
            GraphicsConfiguration gc = win.getGraphicsConfiguration();
            return gc.createCompatibleImage(w, h, t);
        }
        return null;
    }
}

