/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client;

import com.aragon.cache.ResourceLoader;
import com.aragon.client.Client;
import com.aragon.client.RSApplet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

final class RSFrame
extends JFrame {
    public static boolean destroy;
    final RSApplet rsApplet;
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screenSize = this.toolkit.getScreenSize();
    int screenWidth = (int)this.screenSize.getWidth();
    int screenHeight = (int)this.screenSize.getHeight();

    public RSFrame(RSApplet rsapplet, int width, int height, boolean undecorative, boolean resizable) throws IOException {
        this.rsApplet = rsapplet;
        this.setTitle("Aragon");
        this.setUndecorated(undecorative);
        this.setResizable(resizable);
        this.setVisible(true);
        Insets insets = this.getInsets();
        this.setSize(width + insets.left + insets.right, height + insets.top + insets.bottom);
        Client.getClient();
        this.setLocation((this.screenWidth - width) / 2, (this.screenHeight - height) / 2 - this.screenHeight == Client.getMaxHeight() ? 0 : (undecorative ? 0 : 70));
        this.requestFocus();
        this.toFront();
        this.setFocusTraversalKeysEnabled(false);
        this.setBackground(Color.BLACK);
        this.setIconImage(ImageIO.read(ResourceLoader.class.getResourceAsStream("icon.png")));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Object[] options = new String[]{"Yes", "No"};
                int userPrompt = JOptionPane.showOptionDialog(null, "Are you sure you wish to exit?", "Aragon", -1, 2, null, options, options[1]);
                if (userPrompt == 0) {
                    RSFrame.this.launchURL("https://Aragon.com/community/");
                    destroy = true;
                    System.exit(0);
                } else {
                    destroy = false;
                }
            }
        });
    }

    public void launchURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape", "safari"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setClientIcon() throws IOException {
        BufferedImage img = ImageIO.read(ResourceLoader.class.getResourceAsStream("icon.png"));
        if (img == null) {
            return;
        }
        this.setIconImage(img);
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        this.rsApplet.mouseWheelMoved(event);
    }

    @Override
    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        Insets insets = this.getInsets();
        g.translate(insets.left, insets.top);
        return g;
    }

    public int getFrameWidth() {
        Insets insets = this.getInsets();
        return this.getWidth() - (insets.left + insets.right);
    }

    public int getFrameHeight() {
        Insets insets = this.getInsets();
        return this.getHeight() - (insets.top + insets.bottom);
    }

    @Override
    public void update(Graphics g) {
        this.rsApplet.update(g);
    }

    @Override
    public void paint(Graphics g) {
        this.rsApplet.paint(g);
    }
}

