/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client;

import com.aragon.cache.ResourceLoader;
import com.aragon.client.Client;
import com.aragon.client.Configuration;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.client.api.plugin.PluginManager;
import com.aragon.client.api.ui.PluginPanel;
import com.aragon.util.signlink;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JFrameWrapper
extends Client
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static JFrame frame;
    public static TrayIcon trayIcon;
    private JPanel sidebarPanel;
    private JPanel sidebarContent;
    private JButton toggleButton;
    private boolean sidebarExpanded = false;
    private static final int SIDEBAR_COLLAPSED_WIDTH = 40;
    private static final int SIDEBAR_EXPANDED_WIDTH = 250;
    private static final Color SIDEBAR_BG;
    private static final Color SIDEBAR_HOVER;
    private static final Color ACCENT_COLOR;
    private static final int RESIZE_BORDER_WIDTH = 5;
    private boolean isResizing = false;
    private int resizeDirection = 0;
    private Point resizeStartPoint = null;
    private Rectangle resizeStartBounds = null;
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_N = 1;
    private static final int RESIZE_S = 2;
    private static final int RESIZE_W = 4;
    private static final int RESIZE_E = 8;
    private static final int RESIZE_NW = 5;
    private static final int RESIZE_NE = 9;
    private static final int RESIZE_SW = 6;
    private static final int RESIZE_SE = 10;
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screenSize = this.toolkit.getScreenSize();
    int screenWidth = (int)this.screenSize.getWidth();
    int screenHeight = (int)this.screenSize.getHeight();

    static {
        SIDEBAR_BG = new Color(43, 43, 43);
        SIDEBAR_HOVER = new Color(60, 60, 60);
        ACCENT_COLOR = new Color(255, 152, 31);
    }

    public JFrameWrapper(String[] args, int width, int height, boolean resizable) throws IOException {
        this.setTray();
        try {
            signlink.startpriv(InetAddress.getByName(Configuration.getHost()));
            this.initUI(width, height, resizable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTray() {
        if (SystemTray.isSupported()) {
            Image icon = Toolkit.getDefaultToolkit().getImage(String.valueOf(signlink.findcachedir()) + "/Interfaces/icon.png");
            trayIcon = new TrayIcon(icon, "Aragon");
            trayIcon.setImageAutoSize(true);
            try {
                SystemTray tray = SystemTray.getSystemTray();
                tray.add(trayIcon);
                trayIcon.displayMessage("Aragon", "Aragon has been launched!", TrayIcon.MessageType.INFO);
                final MenuItem minimizeItem = new MenuItem("Hide Aragon");
                MenuItem BLANK = new MenuItem("-");
                MenuItem exitItem = new MenuItem("Quit");
                ActionListener minimizeListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (frame.isVisible()) {
                            frame.setVisible(false);
                            minimizeItem.setLabel("Show 1# Aragon.");
                        } else {
                            frame.setVisible(true);
                            minimizeItem.setLabel("Hide 1# Aragon.");
                        }
                    }
                };
                minimizeItem.addActionListener(minimizeListener);
                ActionListener exitListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                };
                exitItem.addActionListener(exitListener);
            }
            catch (AWTException e) {
                System.err.println(e);
            }
        }
    }

    public void initUI(int width, int height, boolean resizable) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            frame = new JFrame("Aragon");
            frame.setIconImage(ResourceLoader.loadImage("/images/Logo.jpg"));
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            frame.setDefaultCloseOperation(0);
            frame.setAlwaysOnTop(false);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    Object[] options = new String[]{"Yes", "No"};
                    int userPrompt = JOptionPane.showOptionDialog(null, "Are you sure you wish to exit?", "Aragon", -1, 2, null, options, options[1]);
                    if (userPrompt == 0) {
                        System.exit(0);
                    }
                }
            });
            this.setFocusTraversalKeysEnabled(false);
            JPanel titleBar = this.createCustomTitleBar();
            JPanel mainContainer = new JPanel(new BorderLayout());
            mainContainer.setBackground(Color.BLACK);
            JPanel gamePanel = new JPanel();
            super.setPreferredSize(new Dimension(width - 10, height));
            gamePanel.setLayout(new BorderLayout());
            gamePanel.add(this);
            gamePanel.setBackground(Color.BLACK);
            gamePanel.setPreferredSize(new Dimension(width - 10, height));
            this.initializeSidebar();
            JFrameWrapper.setPluginManager(new PluginManager("config"));
            JFrameWrapper.getPluginManager().loadPlugins("com.aragon.client.plugins");
            JFrameWrapper.getPluginManager().startPlugins();
            mainContainer.add((Component)gamePanel, "Center");
            mainContainer.add((Component)this.sidebarPanel, "East");
            frame.getContentPane().add((Component)titleBar, "North");
            frame.getContentPane().add((Component)mainContainer, "Center");
            Image iconImg = null;
            try {
                iconImg = ResourceLoader.loadImage("logo.png");
            }
            catch (Exception e) {
                System.err.println("Icon not found: " + e.getMessage());
            }
            if (iconImg != null) {
                frame.setIconImage(iconImg);
                trayIcon.setImage(iconImg);
            }
            frame.pack();
            frame.setResizable(resizable);
            this.init();
            this.graphics = this.getGameComponent().getGraphics();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            if (resizable) {
                this.addResizeListeners();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel createCustomTitleBar() {
        JPanel titleBar = new JPanel(new BorderLayout());
        titleBar.setBackground(SIDEBAR_BG);
        titleBar.setPreferredSize(new Dimension(0, 30));
        titleBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(60, 60, 60)));
        JPanel leftPanel = new JPanel(new FlowLayout(0, 10, 5));
        leftPanel.setBackground(SIDEBAR_BG);
        try {
            ImageIcon icon = new ImageIcon(ResourceLoader.loadImage("logo.png"));
            if (icon != null) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(20, 20, 4));
                JLabel iconLabel = new JLabel(icon);
                leftPanel.add(iconLabel);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        JLabel titleLabel = new JLabel("Aragon");
        titleLabel.setForeground(Color.LIGHT_GRAY);
        titleLabel.setFont(new Font("Dialog", 1, 12));
        leftPanel.add(titleLabel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        buttonPanel.setBackground(SIDEBAR_BG);
        JButton minimizeBtn = this.createTitleBarButton("-");
        JButton maximizeBtn = this.createTitleBarButton("\u25a1");
        final JButton closeBtn = this.createTitleBarButton("X");
        minimizeBtn.addActionListener(e -> frame.setState(1));
        maximizeBtn.addActionListener(e -> {
            if (frame.getExtendedState() == 6) {
                frame.setExtendedState(0);
            } else {
                frame.setExtendedState(6);
            }
        });
        closeBtn.addActionListener(e -> {
            Object[] options = new String[]{"Yes", "No"};
            int userPrompt = JOptionPane.showOptionDialog(null, "Are you sure you wish to exit?", "Aragon", -1, 2, null, options, options[1]);
            if (userPrompt == 0) {
                System.exit(0);
            }
        });
        closeBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                closeBtn.setBackground(new Color(200, 50, 50));
                closeBtn.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                closeBtn.setBackground(SIDEBAR_BG);
                closeBtn.repaint();
            }
        });
        buttonPanel.add(minimizeBtn);
        Client.getClient();
        if (Client.clientSize != 0) {
            buttonPanel.add(maximizeBtn);
        }
        buttonPanel.add(closeBtn);
        titleBar.add((Component)leftPanel, "West");
        titleBar.add((Component)buttonPanel, "East");
        final Point[] initialClick = new Point[1];
        titleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                initialClick[0] = e.getPoint();
            }
        });
        titleBar.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int xMoved = e.getX() - initialClick[0].x;
                int yMoved = e.getY() - initialClick[0].y;
                int x = JFrameWrapper.frame.getLocation().x + xMoved;
                int y = JFrameWrapper.frame.getLocation().y + yMoved;
                frame.setLocation(x, y);
            }
        });
        return titleBar;
    }

    private JButton createTitleBarButton(String text) {
        final JButton btn = new JButton(text){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this.getModel().isRollover()) {
                    g2.setColor(this.getBackground());
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    g2.setColor(SIDEBAR_BG);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                g2.setColor(this.getForeground());
                g2.setFont(this.getFont());
                FontMetrics fm = g2.getFontMetrics();
                int x = (this.getWidth() - fm.stringWidth(this.getText())) / 2;
                int y = (this.getHeight() + fm.getAscent() - fm.getDescent()) / 2;
                g2.drawString(this.getText(), x, y);
                g2.dispose();
            }
        };
        btn.setPreferredSize(new Dimension(45, 30));
        btn.setForeground(Color.LIGHT_GRAY);
        btn.setBackground(SIDEBAR_BG);
        btn.setFocusPainted(false);
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setOpaque(false);
        btn.setCursor(new Cursor(12));
        btn.setFont(new Font("Monospaced", 1, 14));
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                btn.setBackground(SIDEBAR_HOVER);
                btn.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btn.setBackground(SIDEBAR_BG);
                btn.repaint();
            }
        });
        return btn;
    }

    private void initializeSidebar() {
        this.sidebarPanel = new JPanel(new BorderLayout());
        this.sidebarPanel.setBackground(SIDEBAR_BG);
        this.sidebarPanel.setPreferredSize(new Dimension(40, 0));
        this.sidebarPanel.setFocusable(false);
        JPanel iconBar = new JPanel();
        iconBar.setLayout(new BoxLayout(iconBar, 1));
        iconBar.setBackground(SIDEBAR_BG);
        iconBar.setPreferredSize(new Dimension(40, 0));
        this.toggleButton = this.createSidebarIcon("\u2630", "Toggle Sidebar");
        this.toggleButton.addActionListener(e -> this.toggleSidebar());
        iconBar.add(Box.createVerticalStrut(10));
        iconBar.add(this.createSidebarIcon("\ud83c\udfe0", "Home"));
        iconBar.add(this.createSidebarIcon("\ud83d\uded2", "Store"));
        iconBar.add(this.createSidebarIcon("\u2713", "Vote"));
        iconBar.add(this.createSidebarIcon("\ud83d\udcac", "Discord"));
        if (Configuration.ALLOW_PLUGINS) {
            JButton pluginsButton = this.createSidebarIcon("\ud83d\udd0c", "Plugins");
            pluginsButton.addActionListener(e -> {
                this.showPluginList();
                this.toggleSidebar();
            });
            pluginsButton.setActionCommand("Plugins");
            iconBar.add(pluginsButton);
            iconBar.add(Box.createVerticalGlue());
        }
        this.sidebarContent = new JPanel();
        this.sidebarContent.setLayout(new BoxLayout(this.sidebarContent, 1));
        this.sidebarContent.setBackground(SIDEBAR_BG);
        this.sidebarContent.setVisible(false);
        this.sidebarContent.setPreferredSize(new Dimension(210, 0));
        JLabel emptyLabel = new JLabel("Sidebar Content");
        emptyLabel.setForeground(Color.LIGHT_GRAY);
        emptyLabel.setAlignmentX(0.5f);
        emptyLabel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.sidebarContent.add(emptyLabel);
        this.sidebarPanel.add((Component)iconBar, "West");
        this.sidebarPanel.add((Component)this.sidebarContent, "Center");
    }

    private void addResizeListeners() {
        MouseAdapter resizeListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JFrameWrapper.this.resizeDirection = JFrameWrapper.this.getResizeDirection(e);
                if (JFrameWrapper.this.resizeDirection != 0) {
                    JFrameWrapper.this.isResizing = true;
                    JFrameWrapper.this.resizeStartPoint = e.getLocationOnScreen();
                    JFrameWrapper.this.resizeStartBounds = frame.getBounds();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JFrameWrapper.this.isResizing) {
                    JFrameWrapper.this.isResizing = false;
                    JFrameWrapper.this.resizeDirection = 0;
                    JFrameWrapper.this.resizeStartPoint = null;
                    JFrameWrapper.this.resizeStartBounds = null;
                }
                JFrameWrapper.this.updateCursor(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JFrameWrapper.this.isResizing && JFrameWrapper.this.resizeStartPoint != null && JFrameWrapper.this.resizeStartBounds != null) {
                    Point currentPoint = e.getLocationOnScreen();
                    int deltaX = currentPoint.x - ((JFrameWrapper)JFrameWrapper.this).resizeStartPoint.x;
                    int deltaY = currentPoint.y - ((JFrameWrapper)JFrameWrapper.this).resizeStartPoint.y;
                    Rectangle newBounds = new Rectangle(JFrameWrapper.this.resizeStartBounds);
                    if ((JFrameWrapper.this.resizeDirection & 8) != 0) {
                        newBounds.width = Math.max(300, ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.width + deltaX);
                    }
                    if ((JFrameWrapper.this.resizeDirection & 4) != 0) {
                        int newWidth = Math.max(300, ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.width - deltaX);
                        newBounds.x = ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.x + ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.width - newWidth;
                        newBounds.width = newWidth;
                    }
                    if ((JFrameWrapper.this.resizeDirection & 2) != 0) {
                        newBounds.height = Math.max(200, ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.height + deltaY);
                    }
                    if ((JFrameWrapper.this.resizeDirection & 1) != 0) {
                        int newHeight = Math.max(200, ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.height - deltaY);
                        newBounds.y = ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.y + ((JFrameWrapper)JFrameWrapper.this).resizeStartBounds.height - newHeight;
                        newBounds.height = newHeight;
                    }
                    frame.setBounds(newBounds);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!JFrameWrapper.this.isResizing) {
                    JFrameWrapper.this.updateCursor(e);
                }
            }
        };
        frame.addMouseListener(resizeListener);
        frame.addMouseMotionListener(resizeListener);
        this.addResizeListenersToComponents(frame.getContentPane(), resizeListener);
    }

    private void addResizeListenersToComponents(Container container, MouseAdapter listener) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.addMouseListener(listener);
            component.addMouseMotionListener(listener);
            if (component instanceof Container) {
                this.addResizeListenersToComponents((Container)component, listener);
            }
            ++n2;
        }
    }

    private int getResizeDirection(MouseEvent e) {
        int direction = 0;
        Point framePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), frame);
        int x = framePoint.x;
        int y = framePoint.y;
        int width = frame.getWidth();
        int height = frame.getHeight();
        if (x <= 5) {
            direction |= 4;
        }
        if (x >= width - 5) {
            direction |= 8;
        }
        if (y <= 5) {
            direction |= 1;
        }
        if (y >= height - 5) {
            direction |= 2;
        }
        return direction;
    }

    private Cursor getResizeCursor(int direction) {
        switch (direction) {
            case 1: {
                return new Cursor(8);
            }
            case 2: {
                return new Cursor(9);
            }
            case 4: {
                return new Cursor(10);
            }
            case 8: {
                return new Cursor(11);
            }
            case 5: {
                return new Cursor(6);
            }
            case 9: {
                return new Cursor(7);
            }
            case 6: {
                return new Cursor(4);
            }
            case 10: {
                return new Cursor(5);
            }
        }
        return new Cursor(0);
    }

    private void updateCursor(MouseEvent e) {
        int direction = this.getResizeDirection(e);
        frame.setCursor(this.getResizeCursor(direction));
    }

    private void showPluginList() {
        if (JFrameWrapper.getPluginManager() == null) {
            return;
        }
        this.sidebarContent.removeAll();
        this.sidebarContent.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel(new FlowLayout(0, 15, 10));
        titlePanel.setBackground(SIDEBAR_BG);
        JLabel titleLabel = new JLabel("Plugins");
        titleLabel.setFont(new Font("Dialog", 1, 16));
        titleLabel.setForeground(Color.LIGHT_GRAY);
        titlePanel.add(titleLabel);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.setBackground(SIDEBAR_BG);
        for (Plugin plugin : JFrameWrapper.getPluginManager().getPlugins()) {
            PluginInfo info = plugin.getClass().getAnnotation(PluginInfo.class);
            if (info == null) continue;
            JPanel pluginItem = this.createPluginListItem(plugin, info);
            listPanel.add(pluginItem);
            listPanel.add(Box.createVerticalStrut(2));
        }
        JScrollPane scrollPane = PluginPanel.createCustomScrollPane(listPanel);
        this.sidebarContent.add((Component)titlePanel, "North");
        this.sidebarContent.add((Component)scrollPane, "Center");
        this.sidebarContent.revalidate();
        this.sidebarContent.repaint();
    }

    private JPanel createPluginListItem(final Plugin plugin, PluginInfo info) {
        final JPanel itemPanel = new JPanel(new BorderLayout(10, 0)){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.getMousePosition() != null) {
                    g.setColor(SIDEBAR_HOVER);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        itemPanel.setBackground(SIDEBAR_BG);
        itemPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        itemPanel.setCursor(new Cursor(12));
        itemPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        itemPanel.setToolTipText(info.description());
        JLabel nameLabel = new JLabel(info.name());
        nameLabel.setFont(new Font("Dialog", 1, 12));
        nameLabel.setForeground(Color.LIGHT_GRAY);
        CustomToggle toggle = new CustomToggle(info.enabledByDefault());
        toggle.addActionListener(e -> {
            if (toggle.isSelected()) {
                JFrameWrapper.getPluginManager().enablePlugin(plugin.getClass());
            } else {
                JFrameWrapper.getPluginManager().disablePlugin(plugin.getClass());
            }
        });
        itemPanel.add((Component)nameLabel, "Center");
        itemPanel.add((Component)toggle, "East");
        itemPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getX() < itemPanel.getWidth() - 50) {
                    JFrameWrapper.this.showPluginConfig(plugin);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                itemPanel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                itemPanel.repaint();
            }
        });
        return itemPanel;
    }

    private void showPluginConfig(Plugin plugin) {
        this.sidebarContent.removeAll();
        this.sidebarContent.setLayout(new BorderLayout());
        JPanel headerPanel = new JPanel(new FlowLayout(0, 10, 10));
        headerPanel.setBackground(SIDEBAR_BG);
        final JButton backButton = new JButton("\u2190 Back");
        backButton.setForeground(Color.LIGHT_GRAY);
        backButton.setBackground(SIDEBAR_BG);
        backButton.setBorderPainted(false);
        backButton.setFocusPainted(false);
        backButton.setContentAreaFilled(false);
        backButton.setCursor(new Cursor(12));
        backButton.setFont(new Font("Dialog", 1, 12));
        backButton.addActionListener(e -> this.showPluginList());
        backButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                backButton.setForeground(ACCENT_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                backButton.setForeground(Color.LIGHT_GRAY);
            }
        });
        headerPanel.add(backButton);
        PluginPanel configPanel = new PluginPanel(plugin, JFrameWrapper.getPluginManager());
        JScrollPane scrollPane = PluginPanel.createCustomScrollPane(configPanel);
        this.sidebarContent.add((Component)headerPanel, "North");
        this.sidebarContent.add((Component)scrollPane, "Center");
        this.sidebarContent.revalidate();
        this.sidebarContent.repaint();
    }

    private JButton createPluginListButton(String name, String description) {
        JButton button = new JButton(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                if (this.getModel().isRollover()) {
                    g.setColor(SIDEBAR_HOVER);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paintComponent(g);
            }
        };
        button.setLayout(new BorderLayout());
        button.setBackground(SIDEBAR_BG);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setCursor(new Cursor(12));
        button.setAlignmentX(0.0f);
        button.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setOpaque(false);
        textPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        JLabel nameLabel = new JLabel(name);
        nameLabel.setFont(new Font("Dialog", 1, 13));
        nameLabel.setForeground(Color.LIGHT_GRAY);
        nameLabel.setAlignmentX(0.0f);
        JTextArea descArea = new JTextArea(description);
        descArea.setFont(new Font("Dialog", 0, 10));
        descArea.setForeground(Color.LIGHT_GRAY.darker());
        descArea.setLineWrap(true);
        descArea.setWrapStyleWord(true);
        descArea.setOpaque(false);
        descArea.setEditable(false);
        descArea.setFocusable(false);
        descArea.setAlignmentX(0.0f);
        descArea.setBorder(null);
        textPanel.add(nameLabel);
        if (!description.isEmpty()) {
            textPanel.add(Box.createVerticalStrut(2));
            textPanel.add(descArea);
        }
        button.add((Component)textPanel, "Center");
        return button;
    }

    private JButton createSidebarIcon(String icon, String tooltip) {
        JButton btn = new JButton(icon){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isRollover()) {
                    g2.setColor(SIDEBAR_HOVER);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paintComponent(g2);
                g2.dispose();
            }
        };
        btn.setPreferredSize(new Dimension(40, 40));
        btn.setMaximumSize(new Dimension(40, 40));
        btn.setMinimumSize(new Dimension(40, 40));
        btn.setFont(new Font("Dialog", 0, 18));
        btn.setForeground(Color.LIGHT_GRAY);
        btn.setBackground(SIDEBAR_BG);
        btn.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        btn.setFocusPainted(false);
        btn.setContentAreaFilled(false);
        btn.setCursor(new Cursor(12));
        btn.setToolTipText(tooltip);
        btn.setHorizontalAlignment(0);
        if (!tooltip.equals("Toggle Sidebar")) {
            btn.addActionListener(this);
            btn.setActionCommand(tooltip);
        }
        return btn;
    }

    private void toggleSidebar() {
        this.sidebarExpanded = !this.sidebarExpanded;
        Timer timer = new Timer(10, new ActionListener(){
            int currentSidebarWidth;
            int targetSidebarWidth;
            int initialFrameWidth;
            int step;
            {
                this.currentSidebarWidth = ((JFrameWrapper)JFrameWrapper.this).sidebarPanel.getPreferredSize().width;
                this.targetSidebarWidth = JFrameWrapper.this.sidebarExpanded ? 250 : 40;
                this.initialFrameWidth = frame.getWidth();
                this.step = JFrameWrapper.this.sidebarExpanded ? 15 : -15;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean done = false;
                if (JFrameWrapper.this.sidebarExpanded) {
                    this.currentSidebarWidth += this.step;
                    if (this.currentSidebarWidth >= this.targetSidebarWidth) {
                        this.currentSidebarWidth = this.targetSidebarWidth;
                        JFrameWrapper.this.sidebarContent.setVisible(true);
                        done = true;
                    }
                } else {
                    JFrameWrapper.this.sidebarContent.setVisible(false);
                    this.currentSidebarWidth += this.step;
                    if (this.currentSidebarWidth <= this.targetSidebarWidth) {
                        this.currentSidebarWidth = this.targetSidebarWidth;
                        done = true;
                    }
                }
                int widthChange = this.currentSidebarWidth - ((JFrameWrapper)JFrameWrapper.this).sidebarPanel.getPreferredSize().width;
                JFrameWrapper.this.sidebarPanel.setPreferredSize(new Dimension(this.currentSidebarWidth, JFrameWrapper.this.sidebarPanel.getHeight()));
                int newFrameWidth = frame.getWidth() + widthChange;
                frame.setSize(newFrameWidth, frame.getHeight());
                JFrameWrapper.this.sidebarPanel.revalidate();
                frame.revalidate();
                frame.repaint();
                if (done) {
                    ((Timer)e.getSource()).stop();
                }
            }
        });
        timer.start();
    }

    public void rebuildFrame(int width, int height, boolean resizable, boolean undecorated) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        frame = new JFrame("Aragon");
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        frame.setIconImage(ResourceLoader.loadImage("/images/Logo.jpg"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Object[] options = new String[]{"Yes", "No"};
                int userPrompt = JOptionPane.showOptionDialog(null, "Are you sure you wish to exit?", "WAIT!", -1, 2, null, options, options[1]);
                if (userPrompt == 0) {
                    System.exit(-1);
                    System.exit(0);
                }
            }
        });
        frame.setUndecorated(true);
        this.setFocusTraversalKeysEnabled(false);
        JPanel titleBar = this.createCustomTitleBar();
        frame.getContentPane().add((Component)titleBar, "North");
        final JPanel gamePanel = new JPanel();
        super.setPreferredSize(new Dimension(width - 10, height));
        gamePanel.setLayout(new BorderLayout());
        gamePanel.add((Component)this, "Center");
        gamePanel.setBackground(Color.BLACK);
        gamePanel.setPreferredSize(new Dimension(width - 10, height));
        this.initializeSidebar();
        JPanel mainContainer = new JPanel(new BorderLayout());
        mainContainer.setBackground(Color.BLACK);
        mainContainer.add((Component)gamePanel, "Center");
        mainContainer.add((Component)this.sidebarPanel, "East");
        frame.getContentPane().add((Component)mainContainer, "Center");
        Image iconImg = null;
        try {
            iconImg = ResourceLoader.loadImage("logo.png");
        }
        catch (Exception e) {
            System.err.println("Icon not found: " + e.getMessage());
        }
        if (iconImg != null) {
            frame.setIconImage(iconImg);
            trayIcon.setImage(iconImg);
        }
        frame.pack();
        frame.setResizable(resizable);
        this.graphics = this.getGameComponent().getGraphics();
        frame.setLocation((this.screenWidth - width) / 2, (this.screenHeight - height) / 2 - this.screenHeight == Client.getMaxHeight() ? 0 : 0);
        frame.setVisible(true);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dimension = new Dimension(frame.getWidth() - JFrameWrapper.this.sidebarPanel.getWidth(), frame.getHeight());
                gamePanel.setMinimumSize(dimension);
                gamePanel.setPreferredSize(dimension);
                gamePanel.setSize(dimension);
                JFrameWrapper.super.setPreferredSize(new Dimension(frame.getWidth() - JFrameWrapper.this.sidebarPanel.getWidth() - 10, frame.getHeight()));
                JFrameWrapper.super.revalidate();
                JFrameWrapper.super.repaint();
                JFrameWrapper.this.graphics = JFrameWrapper.this.getGameComponent().getGraphics();
            }
        });
        if (resizable) {
            this.addResizeListeners();
        }
    }

    public void setClientIcon() throws IOException {
        BufferedImage img = ImageIO.read(ResourceLoader.class.getResourceAsStream("/images/TrayIcon.jpg"));
        if (img == null) {
            return;
        }
        frame.setIconImage(img);
    }

    @Override
    public URL getCodeBase() {
        try {
            return new URL("http://" + Configuration.getHost() + "/");
        }
        catch (Exception e) {
            return super.getCodeBase();
        }
    }

    @Override
    public URL getDocumentBase() {
        return this.getCodeBase();
    }

    public void loadError(String s) {
        System.out.println("loadError: " + s);
    }

    @Override
    public String getParameter(String key) {
        return "";
    }

    public static void openUpWebSite(String url) {
        Desktop d = Desktop.getDesktop();
        try {
            d.browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        try {
            if (cmd == null) return;
            switch (cmd) {
                case "Home": {
                    JFrameWrapper.openURL("https://aragonrsps.com");
                    return;
                }
                case "Store": {
                    JFrameWrapper.openURL("https://aragonrsps.com/store");
                    return;
                }
                case "Vote": {
                    JFrameWrapper.openURL("https://aragonrsps.com/vote");
                    return;
                }
                case "Discord": {
                    JFrameWrapper.openURL("https://discord.gg/qtx9fN4ezQ");
                }
                default: {
                    return;
                }
                case "Plugins": {
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openURL(String url) {
        Desktop d = Desktop.getDesktop();
        try {
            d.browse(new URI(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class CustomToggle
    extends JToggleButton {
        private static final int WIDTH = 40;
        private static final int HEIGHT = 20;

        public CustomToggle(boolean selected) {
            this.setSelected(selected);
            this.setPreferredSize(new Dimension(40, 20));
            this.setMaximumSize(new Dimension(40, 20));
            this.setMinimumSize(new Dimension(40, 20));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setCursor(new Cursor(12));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.isSelected() ? ACCENT_COLOR : new Color(80, 80, 80));
            g2.fillRoundRect(0, 0, 40, 20, 20, 20);
            int knobX = this.isSelected() ? 20 : 0;
            g2.setColor(Color.WHITE);
            g2.fillOval(knobX + 2, 2, 16, 16);
            g2.dispose();
        }
    }
}

