/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client;

import java.util.HashMap;
import java.util.Iterator;

public final class ClickAntiCheat {
    private static final int SAMPLE_SIZE = 48;
    private static final int LONG_TERM_WINDOW = 12;
    private final long[] intervals = new long[48];
    private int index = 0;
    private long lastClick = -1L;
    private int suspicionLevel = 0;
    private final long[] meanHistory = new long[12];
    private int meanIndex = 0;

    public void recordClick(long nanoTime) {
        if (this.lastClick != -1L) {
            long delta = nanoTime - this.lastClick;
            this.intervals[this.index++ % 48] = delta;
        }
        this.lastClick = nanoTime;
    }

    public boolean analyze() {
        boolean flagged;
        if (this.index < 48) {
            return false;
        }
        double mean = 0.0;
        long[] lArray = this.intervals;
        int n = this.intervals.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            mean += (double)i;
            ++n2;
        }
        mean /= 48.0;
        double variance = 0.0;
        long[] lArray2 = this.intervals;
        int n3 = this.intervals.length;
        int n4 = 0;
        while (n4 < n3) {
            long i = lArray2[n4];
            variance += Math.pow((double)i - mean, 2.0);
            ++n4;
        }
        double stdDev = Math.sqrt(variance /= 48.0);
        double cv = stdDev / mean;
        double entropy = this.calculateEntropy();
        long gcd = this.intervalGCD();
        this.meanHistory[this.meanIndex++ % 12] = (long)mean;
        boolean longTermStable = false;
        if (this.meanIndex >= 12) {
            long avg = 0L;
            long[] lArray3 = this.meanHistory;
            int n5 = this.meanHistory.length;
            int n6 = 0;
            while (n6 < n5) {
                long m = lArray3[n6];
                avg += m;
                ++n6;
            }
            avg /= 12L;
            long varianceLT = 0L;
            long[] lArray4 = this.meanHistory;
            int n7 = this.meanHistory.length;
            int n8 = 0;
            while (n8 < n7) {
                long m = lArray4[n8];
                varianceLT = (long)((double)varianceLT + Math.pow(m - avg, 2.0));
                ++n8;
            }
            longTermStable = (varianceLT /= 12L) < 50000L;
        }
        boolean fastClickFlag = cv < 0.085 && entropy < 2.1 && mean < 1.9E8;
        boolean slowMacroFlag = mean > 7.0E8 && longTermStable && gcd > 20000000L;
        boolean bl = flagged = fastClickFlag || slowMacroFlag;
        this.suspicionLevel = flagged ? ++this.suspicionLevel : Math.max(0, this.suspicionLevel - 1);
        return this.suspicionLevel > 6;
    }

    private double calculateEntropy() {
        HashMap<Long, Integer> freq = new HashMap<Long, Integer>();
        long[] lArray = this.intervals;
        int n = this.intervals.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            long bucket = v / 5000000L;
            freq.merge(bucket, 1, Integer::sum);
            ++n2;
        }
        double entropy = 0.0;
        Iterator iterator = freq.values().iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            double p = (double)c / (double)this.intervals.length;
            entropy -= p * (Math.log(p) / Math.log(2.0));
        }
        return entropy;
    }

    private long intervalGCD() {
        long g = this.intervals[0];
        int i = 1;
        while (i < this.intervals.length) {
            g = this.gcd(g, this.intervals[i]);
            ++i;
        }
        return g;
    }

    private long gcd(long a, long b) {
        while (b != 0L) {
            long t = b;
            b = a % b;
            a = t;
        }
        return Math.abs(a);
    }

    public int getSuspicionLevel() {
        return this.suspicionLevel;
    }
}

