/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache.codec.utils;

import com.aragon.cache.codec.zip.BZip2Decoder;
import com.aragon.cache.codec.zip.BZip2Encoder;
import com.aragon.cache.codec.zip.GZipDecoder;
import com.aragon.cache.codec.zip.GZipEncoder;
import java.util.zip.CRC32;

public final class ZipUtils {
    private static final CRC32 crc32 = new CRC32();
    private static final GZipEncoder GZIP_ENCODER = new GZipEncoder();
    private static final GZipDecoder GZIP_DECODER = new GZipDecoder();
    private static final BZip2Encoder BZIP2_ENCODER = new BZip2Encoder();
    private static final BZip2Decoder BZIP2_DECODER = new BZip2Decoder();

    private ZipUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crc(byte[] data) {
        CRC32 cRC32 = crc32;
        synchronized (cRC32) {
            crc32.reset();
            crc32.update(data);
            return (int)crc32.getValue();
        }
    }

    public static byte[] gzip(byte[] data) {
        return GZIP_ENCODER.encode(data);
    }

    public static byte[] ungzip(byte[] data) {
        return GZIP_DECODER.decode(data);
    }

    public static byte[] bzip2(byte[] data) {
        return BZIP2_ENCODER.encode(data);
    }

    public static byte[] unbzip2(byte[] data) {
        return BZIP2_DECODER.decode(data);
    }
}

