/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache.codec.io;

import java.nio.ByteBuffer;

public final class Buffer {
    private ByteBuffer buf;

    public Buffer() {
        this.buf = ByteBuffer.allocate(32);
    }

    public Buffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0");
        }
        this.buf = ByteBuffer.allocate(capacity);
    }

    public Buffer(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        this.buf = ByteBuffer.wrap(data);
    }

    public int getPosition() {
        return this.buf.position();
    }

    public void setPosition(int pos) {
        this.buf.position(pos);
    }

    public int getCapacity() {
        return this.buf.capacity();
    }

    public byte[] getData() {
        return this.buf.array();
    }

    public byte[] getShrunkData() {
        byte[] bytes = new byte[this.buf.position()];
        System.arraycopy(this.buf.array(), 0, bytes, 0, bytes.length);
        return bytes;
    }

    private void ensureCapacity(int n) {
        if (this.buf.remaining() >= n) {
            return;
        }
        int used = this.buf.capacity() - this.buf.remaining();
        int newCap = this.buf.capacity() << 1;
        if (newCap == 0) {
            newCap = 1;
        }
        while (newCap - used < n) {
            newCap += this.buf.capacity();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(newCap);
        this.buf.flip();
        newBuf.put(this.buf);
        this.buf = newBuf;
    }

    public void putByte(int value) {
        this.ensureCapacity(1);
        this.buf.put((byte)value);
    }

    public void putShort(int value) {
        this.ensureCapacity(2);
        this.buf.putShort((short)value);
    }

    public void putMedium(int value) {
        this.ensureCapacity(3);
        this.buf.put((byte)(value >> 16)).put((byte)(value >> 8)).put((byte)value);
    }

    public void putInt(int value) {
        this.ensureCapacity(4);
        this.buf.putInt(value);
    }

    public void putLong(long value) {
        this.ensureCapacity(8);
        this.buf.putLong(value);
    }

    public void putLine(String value) {
        this.ensureCapacity(value.length() + 1);
        this.buf.put(value.getBytes()).put((byte)10);
    }

    public void putString(String value) {
        this.ensureCapacity(value.length() + 1);
        this.buf.put(value.getBytes()).put((byte)0);
    }

    public void putBytes(byte[] src, int pos, int len) {
        this.ensureCapacity(len);
        this.buf.put(src, pos, len);
    }

    public byte getByte() {
        return this.buf.get();
    }

    public int getUByte() {
        return this.buf.get() & 0xFF;
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public int getUShort() {
        return this.buf.getShort() & 0xFFFF;
    }

    public int getSmart() {
        int i = this.buf.get() & 0xFF;
        if (i < 128) {
            return i - 64;
        }
        return (i << 8) + (this.buf.get() & 0xFF) - 49152;
    }

    public int getUSmart() {
        int i = this.buf.get() & 0xFF;
        if (i < 128) {
            return i;
        }
        return (i << 8) + (this.buf.get() & 0xFF) - 32768;
    }

    public int getMedium() {
        int value = (this.buf.get() & 0xFF) << 16 | (this.buf.get() & 0xFF) << 8 | this.buf.get() & 0xFF;
        if (value > 0x7FFFFF) {
            value -= 0x1000000;
        }
        return value;
    }

    public int getUMedium() {
        return (this.buf.get() & 0xFF) << 16 | (this.buf.get() & 0xFF) << 8 | this.buf.get() & 0xFF;
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public String getLine() {
        byte b;
        StringBuilder sb = new StringBuilder();
        while (this.buf.hasRemaining() && (b = this.buf.get()) != 10) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public String getString() {
        byte b;
        StringBuilder sb = new StringBuilder();
        while (this.buf.hasRemaining() && (b = this.buf.get()) != 0) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public void getBytes(byte[] dst, int pos, int len) {
        this.buf.get(dst, pos, len);
    }
}

