/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache.codec;

import com.aragon.cache.codec.FileStore;
import com.aragon.cache.codec.bzip2.BZip2Decompressor;
import com.aragon.cache.codec.io.Buffer;
import com.aragon.cache.codec.utils.FileSystemUtils;
import com.aragon.cache.codec.utils.ZipUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class FileSystem {
    private final int id;
    private final FileStore fs;
    private final boolean zippedAtOneTime;
    private final List<File> files = new LinkedList<File>();

    protected FileSystem(int id, FileStore fs, byte[] data) {
        this.id = id;
        this.fs = fs;
        Buffer buf = new Buffer(data);
        int origSize = buf.getUMedium();
        int onDiskSize = buf.getUMedium();
        if (origSize != onDiskSize) {
            byte[] tmp = new byte[origSize];
            BZip2Decompressor.decompress(data, 6, tmp, onDiskSize, origSize);
            data = tmp;
            buf = new Buffer(data);
            this.zippedAtOneTime = true;
        } else {
            this.zippedAtOneTime = false;
        }
        int nFiles = buf.getUShort();
        Buffer altBuf = new Buffer(data);
        altBuf.setPosition(buf.getPosition() + nFiles * 10);
        int i = 0;
        while (i < nFiles) {
            File file = new File();
            file.hash = buf.getInt();
            file.origSize = buf.getUMedium();
            file.onDiskSize = buf.getUMedium();
            file.data = new byte[file.onDiskSize];
            altBuf.getBytes(file.data, 0, file.onDiskSize);
            this.files.add(file);
            ++i;
        }
    }

    private synchronized void repack() {
        byte[] data;
        Buffer buf;
        int size = 2 + this.files.size() * 10;
        for (File file : this.files) {
            size += file.onDiskSize;
        }
        if (!this.zippedAtOneTime) {
            buf = new Buffer(size + 6);
            buf.putMedium(size);
            buf.putMedium(size);
        } else {
            buf = new Buffer(size);
        }
        buf.putShort(this.files.size());
        for (File file : this.files) {
            buf.putInt(file.hash);
            buf.putMedium(file.origSize);
            buf.putMedium(file.onDiskSize);
        }
        for (File file : this.files) {
            buf.putBytes(file.data, 0, file.onDiskSize);
        }
        if (!this.zippedAtOneTime) {
            data = buf.getData();
        } else {
            byte[] zipped;
            byte[] unzipped = buf.getData();
            if (unzipped.length == (zipped = ZipUtils.bzip2(unzipped)).length) {
                throw new RuntimeException("error zipped size matches original");
            }
            buf = new Buffer(zipped.length + 6);
            buf.putMedium(unzipped.length);
            buf.putMedium(zipped.length);
            buf.putBytes(zipped, 0, zipped.length);
            data = buf.getData();
        }
        this.fs.writeFileInBackground(this.id, data);
    }

    public void writeFile(String name, byte[] data) {
        this.writeFile(FileSystemUtils.fileNameToHash(name), data);
    }

    public synchronized void writeFile(int hash, byte[] data) {
        File file = null;
        for (File f : this.files) {
            if (f.hash != hash) continue;
            file = f;
            break;
        }
        if (file == null) {
            file = new File();
            file.hash = hash;
            this.files.add(file);
        }
        file.origSize = data.length;
        if (!this.zippedAtOneTime) {
            data = ZipUtils.bzip2(data);
        }
        file.onDiskSize = data.length;
        file.data = data;
        this.repack();
    }

    public byte[] readFile(String name) {
        return this.readFile(FileSystemUtils.fileNameToHash(name));
    }

    public synchronized byte[] readFile(int hash) {
        for (File file : this.files) {
            if (file.hash != hash) continue;
            byte[] data = new byte[file.origSize];
            if (this.zippedAtOneTime) {
                System.arraycopy(file.data, 0, data, 0, data.length);
            } else {
                BZip2Decompressor.decompress(file.data, 0, data, file.onDiskSize, file.origSize);
            }
            return data;
        }
        throw new RuntimeException("file not found");
    }

    public void removeFile(String name) {
        this.removeFile(FileSystemUtils.fileNameToHash(name));
    }

    public synchronized void removeFile(int hash) {
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File file = i.next();
            if (file.hash != hash) continue;
            i.remove();
            this.repack();
            return;
        }
        throw new RuntimeException("file not found");
    }

    public boolean containsFile(String name) {
        return this.containsFile(FileSystemUtils.fileNameToHash(name));
    }

    public synchronized boolean containsFile(int hash) {
        for (File file : this.files) {
            if (file.hash != hash) continue;
            return true;
        }
        return false;
    }

    public synchronized int getFileCount() {
        return this.files.size();
    }

    public synchronized int[] getFileList() {
        int size = this.files.size();
        int[] a = new int[size];
        int i = 0;
        while (i < size) {
            a[i] = this.files.get(i).hash;
            ++i;
        }
        return a;
    }

    private static final class File {
        private int hash;
        private int origSize;
        private int onDiskSize;
        private byte[] data;

        private File() {
        }
    }
}

