/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache.codec;

import com.aragon.cache.codec.utils.ZipUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;

public final class FileStore {
    private static final Object lock = new Object();
    private static final Queue<ReadEntry> readEntries = new LinkedList<ReadEntry>();
    private static final Queue<WriteEntry> writeEntries = new LinkedList<WriteEntry>();
    private static boolean running;
    private static volatile boolean exiting;
    private static Thread thread;
    private final int id;
    private final RandomAccessFile dat;
    private final RandomAccessFile idx;
    private final boolean gzip;
    private final byte[] buffer;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting = true;
            Object object = lock;
            synchronized (object) {
                if (running) {
                    try {
                        thread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBackgroundThread() {
        Object object = lock;
        synchronized (object) {
            if (!running) {
                running = true;
                thread = new Thread(() -> {
                    while (true) {
                        ReadEntry readEntry = null;
                        WriteEntry writeEntry = null;
                        Object object = lock;
                        synchronized (object) {
                            if ((exiting || readEntries.isEmpty()) && writeEntries.isEmpty()) {
                                running = false;
                                break;
                            }
                            if (!exiting && !readEntries.isEmpty()) {
                                readEntry = readEntries.remove();
                            } else {
                                writeEntry = writeEntries.remove();
                            }
                        }
                        if (readEntry != null) {
                            byte[] data = readEntry.store.readFile(readEntry.id);
                            if (exiting) continue;
                            readEntry.listener.accept(data);
                            continue;
                        }
                        writeEntry.store.writeFile(writeEntry.id, writeEntry.data);
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    protected FileStore(int id, RandomAccessFile dat, RandomAccessFile idx, boolean gzip, byte[] buffer) {
        this.id = id + 1;
        this.dat = dat;
        this.idx = idx;
        this.gzip = gzip;
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFileInBackground(int id, Consumer<byte[]> listener) {
        Object object = lock;
        synchronized (object) {
            readEntries.add(new ReadEntry(this, id, listener));
            FileStore.runBackgroundThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(int id) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte[] buf;
            try {
                int fileSize;
                this.seek(this.idx, id * 6);
                int i = 0;
                while (i < 6) {
                    fileSize = this.idx.read(this.buffer, i, 6 - i);
                    if (fileSize == -1) {
                        throw new RuntimeException("file does not exist: " + id);
                    }
                    i += fileSize;
                }
                fileSize = ((this.buffer[0] & 0xFF) << 16) + ((this.buffer[1] & 0xFF) << 8) + (this.buffer[2] & 0xFF);
                int frag = ((this.buffer[3] & 0xFF) << 16) + ((this.buffer[4] & 0xFF) << 8) + (this.buffer[5] & 0xFF);
                if (fileSize < 0) {
                    throw new RuntimeException("negative file size: " + id);
                }
                if (frag <= 0 || (long)frag > this.dat.length() / 520L) {
                    throw new RuntimeException("fragment pointer out of bounds");
                }
                buf = new byte[fileSize];
                int nRead = 0;
                int fragCount = 0;
                while (nRead < fileSize) {
                    int fileId;
                    if (frag == 0) {
                        throw new RuntimeException("null fragment pointer");
                    }
                    this.seek(this.dat, frag * 520);
                    int size = 0;
                    int nToRead = fileSize - nRead;
                    if (nToRead > 512) {
                        nToRead = 512;
                    }
                    while (size < nToRead + 8) {
                        fileId = this.dat.read(this.buffer, size, nToRead + 8 - size);
                        if (fileId == -1) {
                            throw new RuntimeException("out of data file bounds");
                        }
                        size += fileId;
                    }
                    fileId = ((this.buffer[0] & 0xFF) << 8) + (this.buffer[1] & 0xFF);
                    int fragId = ((this.buffer[2] & 0xFF) << 8) + (this.buffer[3] & 0xFF);
                    int nextFrag = ((this.buffer[4] & 0xFF) << 16) + ((this.buffer[5] & 0xFF) << 8) + (this.buffer[6] & 0xFF);
                    int nextStoreId = this.buffer[7] & 0xFF;
                    if (fileId != id || fragId != fragCount || nextStoreId != this.id) {
                        throw new RuntimeException("fragment header mismatch");
                    }
                    if (nextFrag < 0 || (long)nextFrag > this.dat.length() / 520L) {
                        throw new RuntimeException("fragment pointer out of bounds");
                    }
                    int i2 = 0;
                    while (i2 < nToRead) {
                        buf[nRead++] = this.buffer[i2 + 8];
                        ++i2;
                    }
                    frag = nextFrag;
                    ++fragCount;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("io error occurred");
            }
            if (this.gzip) {
                buf = ZipUtils.ungzip(buf);
            }
            return buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFileInBackground(int id, byte[] data) {
        Object object = lock;
        synchronized (object) {
            writeEntries.add(new WriteEntry(this, id, data));
            FileStore.runBackgroundThread();
        }
    }

    public void writeFile(int id, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (this.gzip) {
            data = ZipUtils.gzip(data);
        }
        this.writeFile(id, data, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(int id, byte[] buf, int len) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            boolean success = this.writeFile(id, buf, len, true);
            if (!success) {
                success = this.writeFile(id, buf, len, false);
            }
            if (!success) {
                throw new RuntimeException("error writing file");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean writeFile(int id, byte[] buf, int len, boolean first) {
        try {
            int sector;
            if (first) {
                this.seek(this.idx, id * 6);
                int i = 0;
                while (i < 6) {
                    int size = this.idx.read(this.buffer, i, 6 - i);
                    if (size == -1) {
                        return false;
                    }
                    i += size;
                }
                sector = ((this.buffer[3] & 0xFF) << 16) + ((this.buffer[4] & 0xFF) << 8) + (this.buffer[5] & 0xFF);
                if (sector <= 0 || (long)sector > this.dat.length() / 520L) {
                    return false;
                }
            } else {
                sector = (int)((this.dat.length() + 519L) / 520L);
                if (sector == 0) {
                    sector = 1;
                }
            }
            this.buffer[0] = (byte)(len >> 16);
            this.buffer[1] = (byte)(len >> 8);
            this.buffer[2] = (byte)len;
            this.buffer[3] = (byte)(sector >> 16);
            this.buffer[4] = (byte)(sector >> 8);
            this.buffer[5] = (byte)sector;
            this.seek(this.idx, id * 6);
            this.idx.write(this.buffer, 0, 6);
            int written = 0;
            int zero = 0;
            while (written < len) {
                int nextSector = 0;
                if (first) {
                    int currentFile;
                    this.seek(this.dat, sector * 520);
                    int idx = 0;
                    while (idx < 8) {
                        currentFile = this.dat.read(this.buffer, idx, 8 - idx);
                        if (currentFile == -1) break;
                        idx += currentFile;
                    }
                    if (idx == 8) {
                        currentFile = ((this.buffer[0] & 0xFF) << 8) + (this.buffer[1] & 0xFF);
                        int currentPart = ((this.buffer[2] & 0xFF) << 8) + (this.buffer[3] & 0xFF);
                        nextSector = ((this.buffer[4] & 0xFF) << 16) + ((this.buffer[5] & 0xFF) << 8) + (this.buffer[6] & 0xFF);
                        int currentCache = this.buffer[7] & 0xFF;
                        if (currentFile != id || currentPart != zero || currentCache != this.id) {
                            return false;
                        }
                        if (nextSector < 0 || (long)nextSector > this.dat.length() / 520L) {
                            return false;
                        }
                    }
                }
                if (nextSector == 0) {
                    first = false;
                    nextSector = (int)((this.dat.length() + 519L) / 520L);
                    if (nextSector == 0) {
                        ++nextSector;
                    }
                    if (nextSector == sector) {
                        ++nextSector;
                    }
                }
                if (len - written <= 512) {
                    nextSector = 0;
                }
                this.buffer[0] = (byte)(id >> 8);
                this.buffer[1] = (byte)id;
                this.buffer[2] = (byte)(zero >> 8);
                this.buffer[3] = (byte)zero;
                this.buffer[4] = (byte)(nextSector >> 16);
                this.buffer[5] = (byte)(nextSector >> 8);
                this.buffer[6] = (byte)nextSector;
                this.buffer[7] = (byte)this.id;
                this.seek(this.dat, sector * 520);
                this.dat.write(this.buffer, 0, 8);
                int remaining = len - written;
                if (remaining > 512) {
                    remaining = 512;
                }
                this.dat.write(buf, written, remaining);
                written += remaining;
                sector = nextSector;
                ++zero;
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("io error occurred");
        }
    }

    private void seek(RandomAccessFile file, int pos) throws IOException {
        file.seek(pos);
    }

    public int getFileCount() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            try {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (int)(this.idx.length() / 6L);
            }
            catch (IOException e) {
                throw new RuntimeException("error getting file count");
            }
        }
    }

    private static final class ReadEntry {
        private final FileStore store;
        private final int id;
        private final Consumer<byte[]> listener;

        private ReadEntry(FileStore store, int id, Consumer<byte[]> listener) {
            this.store = store;
            this.id = id;
            this.listener = listener;
        }
    }

    private static final class WriteEntry {
        private final FileStore store;
        private final int id;
        private final byte[] data;

        private WriteEntry(FileStore store, int id, byte[] data) {
            this.store = store;
            this.id = id;
            this.data = data;
        }
    }
}

