/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache.codec;

import com.aragon.cache.codec.FileStore;
import com.aragon.cache.codec.FileSystem;
import com.aragon.cache.codec.io.Buffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public final class Cache {
    public static final int N_FILE_STORES = 5;
    public static final int FS_FILE_STORE = 0;
    public static final int MODEL_FILE_STORE = 1;
    public static final int ANIM_FILE_STORE = 2;
    public static final int MIDI_FILE_STORE = 3;
    public static final int MAP_FILE_STORE = 4;
    public static final int N_FILE_SYSTEMS = 9;
    public static final int TITLE_FILE_SYSTEM = 1;
    public static final int CONFIG_FILE_SYSTEM = 2;
    public static final int INTERFACE_FILE_SYSTEM = 3;
    public static final int MEDIA_FILE_SYSTEM = 4;
    public static final int VERSIONLIST_FILE_SYSTEM = 5;
    public static final int TEXTURES_FILE_SYSTEM = 6;
    public static final int WORDENC_FILE_SYSTEM = 7;
    public static final int SOUNDS_FILE_SYSTEM = 8;
    private final String dir;
    private final RandomAccessFile dat;
    private final Map<Integer, FileStore> stores = new HashMap<Integer, FileStore>();
    private final Map<Integer, FileSystem> systems = new HashMap<Integer, FileSystem>();
    private final byte[] buffer = new byte[520];

    public Cache(String dir) {
        dir = Cache.formatDir(dir);
        File dirf = new File(dir);
        if (!dirf.exists()) {
            throw new RuntimeException("dir does not exist");
        }
        if (!dirf.isDirectory()) {
            throw new RuntimeException("dir is not valid");
        }
        this.dir = dir;
        String path = Cache.datPath(dir);
        try {
            this.dat = new RandomAccessFile(path, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("unable to access file: " + path);
        }
    }

    public FileStore getFileStore(int id) {
        if (id < 0 || id >= 255) {
            throw new IllegalArgumentException("id out of range: " + id);
        }
        FileStore fs = this.stores.get(id);
        if (fs != null) {
            return fs;
        }
        Cache cache = this;
        synchronized (cache) {
            fs = this.stores.get(id);
            if (fs != null) {
                return fs;
            }
            String path = Cache.idxPath(this.dir, id);
            File file = new File(path);
            if (!file.exists()) {
                throw new IllegalStateException("file store does not exist");
            }
            try {
                RandomAccessFile idx = new RandomAccessFile(path, "rw");
                fs = new FileStore(id, this.dat, idx, id != 0, this.buffer);
                this.stores.put(id, fs);
                return fs;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("unable to access file: " + path);
            }
        }
    }

    public FileStore createFileStore(int id) {
        if (id < 0 || id >= 255) {
            throw new IllegalArgumentException("id out of range: " + id);
        }
        Cache cache = this;
        synchronized (cache) {
            boolean exists = false;
            if (this.stores.containsKey(id)) {
                exists = true;
            } else {
                File file = new File(Cache.idxPath(this.dir, id));
                if (file.exists()) {
                    exists = true;
                }
            }
            if (exists) {
                throw new IllegalStateException("file store already exists");
            }
            String path = Cache.idxPath(this.dir, id);
            try {
                RandomAccessFile idx = new RandomAccessFile(path, "rw");
                FileStore fs = new FileStore(id, this.dat, idx, id != 0, this.buffer);
                this.stores.put(id, fs);
                return fs;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("unable to access file: " + path);
            }
        }
    }

    public FileStore getOrCreateFileStore(int id) {
        if (id < 0 || id >= 255) {
            throw new IllegalArgumentException("id out of range: " + id);
        }
        FileStore fs = this.stores.get(id);
        if (fs != null) {
            return fs;
        }
        Cache cache = this;
        synchronized (cache) {
            fs = this.stores.get(id);
            if (fs != null) {
                return fs;
            }
            String path = Cache.idxPath(this.dir, id);
            try {
                RandomAccessFile idx = new RandomAccessFile(path, "rw");
                fs = new FileStore(id, this.dat, idx, id != 0, this.buffer);
                this.stores.put(id, fs);
                return fs;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("unable to access file: " + path);
            }
        }
    }

    public boolean containsFileStore(int id) {
        try {
            this.getFileStore(id);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem(int id) {
        FileSystem fs = this.systems.get(id);
        if (fs != null) {
            return fs;
        }
        Cache cache = this;
        synchronized (cache) {
            fs = this.systems.get(id);
            if (fs != null) {
                return fs;
            }
            FileStore store = this.getOrCreateFileStore(0);
            byte[] data = null;
            try {
                data = store.readFile(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data == null) {
                throw new IllegalStateException("file system does not exist");
            }
            fs = new FileSystem(id, store, data);
            this.systems.put(id, fs);
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem createFileSystem(int id) {
        Cache cache = this;
        synchronized (cache) {
            if (this.systems.containsKey(id)) {
                throw new IllegalStateException("file system already exists");
            }
            FileStore store = this.getOrCreateFileStore(0);
            byte[] data = null;
            try {
                data = store.readFile(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data != null) {
                FileSystem fs = new FileSystem(id, store, data);
                this.systems.put(id, fs);
                throw new IllegalStateException("file system already exists");
            }
            data = Cache.emptyFileSystemData();
            store.writeFile(id, data);
            FileSystem fs = new FileSystem(id, store, data);
            this.systems.put(id, fs);
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getOrCreateFileSystem(int id) {
        FileSystem fs = this.systems.get(id);
        if (fs != null) {
            return fs;
        }
        Cache cache = this;
        synchronized (cache) {
            fs = this.systems.get(id);
            if (fs != null) {
                return fs;
            }
            FileStore store = this.getOrCreateFileStore(0);
            byte[] data = null;
            try {
                data = store.readFile(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data == null) {
                data = Cache.emptyFileSystemData();
                store.writeFile(id, data);
            }
            fs = new FileSystem(id, store, data);
            this.systems.put(id, fs);
            return fs;
        }
    }

    private static byte[] emptyFileSystemData() {
        Buffer buf = new Buffer(8);
        buf.putMedium(2);
        buf.putMedium(2);
        buf.putShort(0);
        return buf.getData();
    }

    public boolean containsFileSystem(int id) {
        try {
            this.getFileSystem(id);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    private static String formatDir(String dir) {
        return (String.valueOf(dir) + '/').replaceAll("\\+|/+", "/");
    }

    private static String datPath(String dir) {
        return String.valueOf(dir) + "main_file_cache.dat";
    }

    private static String idxPath(String dir, int id) {
        return String.valueOf(dir) + "main_file_cache.idx" + id;
    }
}

