/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ConcurrentHashMap;

public final class Decompressor {
    private final ConcurrentHashMap<String, byte[]> memoryCache = new ConcurrentHashMap();
    private static final String PREFIX = "MAP_DATA_";
    private static final byte[] buffer = new byte[520];
    private final RandomAccessFile dataFile;
    private final RandomAccessFile indexFile;
    private final int anInt311;

    public Decompressor(RandomAccessFile randomaccessfile, RandomAccessFile randomaccessfile1, int j) {
        this.anInt311 = j;
        this.dataFile = randomaccessfile;
        this.indexFile = randomaccessfile1;
    }

    public long getFileCount() {
        try {
            if (this.indexFile != null) {
                return this.indexFile.length() / 6L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] get(int i) {
        if (this.memoryCache.containsKey(PREFIX + i)) {
            return this.memoryCache.get(PREFIX + i);
        }
        try {
            int j1;
            int i1;
            this.seekTo(this.indexFile, i * 6);
            int j = 0;
            while (true) {
                if (j >= 6) {
                    i1 = ((buffer[0] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[2] & 0xFF);
                    j1 = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                    if (j1 > 0) break;
                    return null;
                }
                int l = this.indexFile.read(buffer, j, 6 - j);
                if (l == -1) {
                    return null;
                }
                j += l;
            }
            byte[] abyte0 = new byte[i1];
            int k1 = 0;
            int l1 = 0;
            block3: while (true) {
                int i3;
                if (k1 >= i1) {
                    return abyte0;
                }
                if (j1 == 0) {
                    return null;
                }
                this.seekTo(this.dataFile, j1 * 520);
                int k = 0;
                int i2 = i1 - k1;
                if (i2 > 512) {
                    i2 = 512;
                }
                while (true) {
                    if (k >= i2 + 8) {
                        int k2 = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                        int l2 = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                        i3 = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                        int j3 = buffer[7] & 0xFF;
                        if (k2 == i && l2 == l1 && j3 == this.anInt311) break;
                        return null;
                    }
                    int j2 = this.dataFile.read(buffer, k, i2 + 8 - k);
                    if (j2 == -1) {
                        return null;
                    }
                    k += j2;
                }
                if (i3 < 0) {
                    return null;
                }
                int k3 = 0;
                while (true) {
                    if (k3 >= i2) {
                        j1 = i3;
                        ++l1;
                        continue block3;
                    }
                    abyte0[k1++] = buffer[k3 + 8];
                    ++k3;
                }
                break;
            }
        }
        catch (IOException _ex) {
            return null;
        }
    }

    public synchronized boolean put(int length, byte[] data, int index) {
        boolean entered = this.enterData(true, index, length, data);
        if (!entered) {
            entered = this.enterData(false, index, length, data);
        }
        return entered;
    }

    public synchronized boolean putMemory(int length, byte[] data, int index) {
        return this.enterDataMemory(index, length, data);
    }

    private synchronized boolean enterDataMemory(int index, int length, byte[] data) {
        block3: {
            try {
                if (data != null && length > 0 && length <= data.length) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        byte[] cachedData = new byte[length];
        System.arraycopy(data, 0, cachedData, 0, length);
        this.memoryCache.put(PREFIX + index, cachedData);
        return true;
    }

    public synchronized boolean removeFromMemory(int index) {
        return this.memoryCache.remove(PREFIX + index) != null;
    }

    public synchronized boolean existsInMemory(int index) {
        return this.memoryCache.containsKey(PREFIX + index);
    }

    public synchronized void clearMemoryCache() {
        this.memoryCache.clear();
    }

    public synchronized int getMemoryCacheSize() {
        return this.memoryCache.size();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean enterData(boolean exists, int index, int length, byte[] data) {
        try {
            int l;
            if (exists) {
                this.seekTo(this.indexFile, index * 6);
                int i1 = 0;
                while (i1 < 6) {
                    int k1 = this.indexFile.read(buffer, i1, 6 - i1);
                    if (k1 == -1) {
                        return false;
                    }
                    i1 += k1;
                }
                l = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                if (l <= 0) {
                    return false;
                }
            } else {
                l = (int)((this.dataFile.length() + 519L) / 520L);
                if (l == 0) {
                    l = 1;
                }
            }
            Decompressor.buffer[0] = (byte)(length >> 16);
            Decompressor.buffer[1] = (byte)(length >> 8);
            Decompressor.buffer[2] = (byte)length;
            Decompressor.buffer[3] = (byte)(l >> 16);
            Decompressor.buffer[4] = (byte)(l >> 8);
            Decompressor.buffer[5] = (byte)l;
            this.seekTo(this.indexFile, index * 6);
            this.indexFile.write(buffer, 0, 6);
            int j1 = 0;
            int l1 = 0;
            while (j1 < length) {
                int i2 = 0;
                if (exists) {
                    this.seekTo(this.dataFile, l * 520);
                    int j2 = 0;
                    while (j2 < 8) {
                        int l2 = this.dataFile.read(buffer, j2, 8 - j2);
                        if (l2 == -1) break;
                        j2 += l2;
                    }
                    if (j2 == 8) {
                        int i3 = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                        int j3 = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                        i2 = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                        int k3 = buffer[7] & 0xFF;
                        if (i3 != index || j3 != l1 || k3 != this.anInt311) {
                            return false;
                        }
                        if (i2 < 0) {
                            return false;
                        }
                    }
                }
                if (i2 == 0) {
                    exists = false;
                    i2 = (int)((this.dataFile.length() + 519L) / 520L);
                    if (i2 == 0) {
                        ++i2;
                    }
                    if (i2 == l) {
                        ++i2;
                    }
                }
                if (length - j1 <= 512) {
                    i2 = 0;
                }
                Decompressor.buffer[0] = (byte)(index >> 8);
                Decompressor.buffer[1] = (byte)index;
                Decompressor.buffer[2] = (byte)(l1 >> 8);
                Decompressor.buffer[3] = (byte)l1;
                Decompressor.buffer[4] = (byte)(i2 >> 16);
                Decompressor.buffer[5] = (byte)(i2 >> 8);
                Decompressor.buffer[6] = (byte)i2;
                Decompressor.buffer[7] = (byte)this.anInt311;
                this.seekTo(this.dataFile, l * 520);
                this.dataFile.write(buffer, 0, 8);
                int k2 = length - j1;
                if (k2 > 512) {
                    k2 = 512;
                }
                this.dataFile.write(data, j1, k2);
                j1 += k2;
                l = i2;
                ++l1;
            }
            return true;
        }
        catch (IOException _ex) {
            return false;
        }
    }

    private synchronized void seekTo(RandomAccessFile randomaccessfile, int j) throws IOException {
        try {
            randomaccessfile.seek(j);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

