/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache;

import com.aragon.client.Client;
import com.aragon.util.signlink;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class CacheDownloader
implements Runnable {
    public static final String DIRECTORY = String.valueOf(System.getProperty("user.home")) + "/Aragon/";
    private static final String ZIP_URL = "https://aragonrsps.com/Aragon.zip";
    private Client client;
    private GUI g;

    public CacheDownloader(Client client) {
        this.client = client;
    }

    private void handleException(Exception e) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("Please Screenshot this message, and send it to an admin!\r\n\r\n");
        strBuff.append(String.valueOf(e.getClass().getName()) + " \"" + e.getMessage() + "\"\r\n");
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            strBuff.append(String.valueOf(s.toString()) + "\r\n");
            ++n2;
        }
        e.printStackTrace();
        this.alert("Exception [" + e.getClass().getSimpleName() + "]", strBuff.toString(), true);
    }

    private void alert(String title, String msg, boolean error) {
        JOptionPane.showMessageDialog(null, msg, title, error ? 0 : -1);
    }

    @Override
    public void run() {
        try {
            this.updateCache();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public static boolean firstTime() {
        boolean firstTime = !new File(String.valueOf(DIRECTORY) + "firstTime").exists();
        return firstTime;
    }

    private void updateCache() {
        File clientZip = this.downloadCache();
        if (clientZip != null) {
            this.unZip(clientZip);
            try {
                boolean bl = new File(String.valueOf(DIRECTORY) + "firstTime").createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void unZip(File clientZip) {
        try {
            this.unZipFile(clientZip, new File(signlink.findcachedir()));
            Files.delete(clientZip.toPath());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void unZipFile(File zipFile, File outFolder) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            long totalBytes = zipFile.length();
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(outFolder, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                File parentDir = new File(newFile.getParent());
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                Throwable throwable2 = null;
                Object var12_14 = null;
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int length;
                    byte[] buffer = new byte[1024];
                    long bytesRead = 0L;
                    while ((length = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                        int progress = (int)((bytesRead += (long)length) * 100L / entry.getSize());
                        this.publish(progress, "Unzipping Aragon Cache");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void publish(String text) {
        this.client.setLoadingText(10, text);
    }

    public void publish(int percent, String text) {
        this.client.setLoadingText(percent, String.valueOf(percent) + "% - " + text);
    }

    private File downloadCache() {
        File ret = new File(String.valueOf(DIRECTORY) + "Aragon.zip");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(ret);){
                int len;
                URLConnection conn = new URL(ZIP_URL).openConnection();
                InputStream in = conn.getInputStream();
                long max = conn.getContentLength();
                long curr = 0L;
                byte[] b = new byte[1024];
                while ((len = in.read(b, 0, b.length)) > -1) {
                    ((OutputStream)out).write(b, 0, len);
                    this.publish((int)((curr += (long)len) * 100L / max), "Downloading Aragon Cache");
                }
                out.flush();
                in.close();
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.handleException(e);
            ret.delete();
            return null;
        }
    }

    public class GUI
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private int percent = 0;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JProgressBar jProgressBar1;

        public GUI() {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initComponents();
        }

        private void initComponents() {
            this.jProgressBar1 = new JProgressBar();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.setDefaultCloseOperation(2);
            this.setTitle("Orudis Cache  Update");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GUI.this.formWindowClosing(evt);
                }
            });
            this.jLabel1.setText("Status:");
            this.jLabel2.setText("N/A");
            this.jLabel3.setText("");
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 304, Short.MAX_VALUE).addComponent(this.jLabel3)).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE)).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3)).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
            this.pack();
        }

        private void formWindowClosing(WindowEvent evt) {
        }

        public void setStatus(String s) {
            this.jLabel2.setText(s);
        }

        public String getStatus() {
            return this.jLabel2.getText();
        }

        public void setPercent(int amount) {
            this.percent = amount;
            this.jProgressBar1.setValue(amount);
        }

        public int getPercent() {
            return this.percent;
        }
    }
}

