/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.cache;

import com.aragon.cache.codec.bzip2.BZ2InputStream;
import com.aragon.util.Stream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CacheArchive {
    private byte[] outputData;
    private int dataSize;
    private int[] myNameIndexes;
    private int[] myFileSizes;
    private int[] myOnDiskFileSizes;
    private int[] myFileOffsets;
    private boolean isCompressed;

    public CacheArchive(byte[] b, String s) {
        this.a(b);
    }

    public CacheArchive(byte[] abyte0) {
        Stream stream = new Stream(abyte0);
        int i = stream.read3Bytes();
        int j = stream.read3Bytes();
        if (j != i) {
            byte[] abyte1 = new byte[i];
            BZ2InputStream.decompressBuffer(abyte1, i, abyte0, j, 6);
            this.outputData = abyte1;
            stream = new Stream(this.outputData);
            this.isCompressed = true;
        } else {
            this.outputData = abyte0;
            this.isCompressed = false;
        }
        this.dataSize = stream.readUnsignedWord();
        this.myNameIndexes = new int[this.dataSize];
        this.myFileSizes = new int[this.dataSize];
        this.myOnDiskFileSizes = new int[this.dataSize];
        this.myFileOffsets = new int[this.dataSize];
        int k = stream.currentOffset + this.dataSize * 10;
        int l = 0;
        while (l < this.dataSize) {
            this.myNameIndexes[l] = stream.readDWord();
            this.myFileSizes[l] = stream.read3Bytes();
            this.myOnDiskFileSizes[l] = stream.read3Bytes();
            this.myFileOffsets[l] = k;
            k += this.myOnDiskFileSizes[l];
            ++l;
        }
    }

    public void a(byte[] abyte0) {
        Stream stream = new Stream(abyte0);
        int i = stream.read3Bytes();
        int j = stream.read3Bytes();
        if (j != i) {
            byte[] abyte1 = new byte[i];
            BZ2InputStream.decompressBuffer(abyte1, i, abyte0, j, 6);
            this.outputData = abyte1;
            stream = new Stream(this.outputData);
            this.isCompressed = true;
        } else {
            this.outputData = abyte0;
            this.isCompressed = false;
        }
        this.dataSize = stream.readUnsignedWord();
        this.myNameIndexes = new int[this.dataSize];
        this.myFileSizes = new int[this.dataSize];
        this.myOnDiskFileSizes = new int[this.dataSize];
        this.myFileOffsets = new int[this.dataSize];
        int k = stream.currentOffset + this.dataSize * 10;
        int l = 0;
        while (l < this.dataSize) {
            this.myNameIndexes[l] = stream.readDWord();
            this.myFileSizes[l] = stream.read3Bytes();
            this.myOnDiskFileSizes[l] = stream.read3Bytes();
            this.myFileOffsets[l] = k;
            k += this.myOnDiskFileSizes[l];
            ++l;
        }
    }

    public byte[] getDataForName(String s) {
        byte[] abyte0 = null;
        int i = 0;
        s = s.toUpperCase();
        int j = 0;
        while (j < s.length()) {
            i = i * 61 + s.charAt(j) - 32;
            ++j;
        }
        int k = 0;
        while (k < this.dataSize) {
            if (this.myNameIndexes[k] == i) {
                if (abyte0 == null) {
                    abyte0 = new byte[this.myFileSizes[k]];
                }
                if (!this.isCompressed) {
                    BZ2InputStream.decompressBuffer(abyte0, this.myFileSizes[k], this.outputData, this.myOnDiskFileSizes[k], this.myFileOffsets[k]);
                } else {
                    System.arraycopy(this.outputData, this.myFileOffsets[k], abyte0, 0, this.myFileSizes[k]);
                }
                return abyte0;
            }
            ++k;
        }
        return null;
    }

    public byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

